/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.io.sentry.Sentry;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.module.chat.ChatFormatter;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.module.chat.ScrollingChat;
import net.creeperhost.minetogether.module.chat.screen.FriendRequestScreen;
import net.creeperhost.minetogether.module.chat.screen.MutedListScreen;
import net.creeperhost.minetogether.module.chat.screen.listentries.ListEntryFriend;
import net.creeperhost.minetogether.screen.MineTogetherScreen;
import net.creeperhost.minetogether.threads.FriendUpdateThread;
import net.creeperhost.polylib.client.screen.widget.ScreenList;
import net.creeperhost.polylib.client.screen.widget.ScreenListEntry;
import net.creeperhost.polylib.client.screen.widget.buttons.ButtonMultiple;
import net.creeperhost.polylib.client.screen.widget.buttons.ButtonString;
import net.creeperhost.polylib.client.toast.SimpleToast;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class FriendsListScreen
extends MineTogetherScreen {
    private final Screen parent;
    private ScreenList<ListEntryFriend> list;
    private ScrollingChat chat;
    private EditBox chatBox;
    private EditBox searchEntry;
    private int ticks;
    private Profile targetProfile = null;
    private Button removeFriend;
    private Button blockButton;
    private Button partyButton;
    private Button friendCodeButton;
    private Button editButton;
    private Button mutedList;
    public static ArrayList<Profile> removedFriends = new ArrayList();

    public FriendsListScreen(Screen parent) {
        super((Component)new TranslatableComponent("minetogether.friendscreen.title"));
        this.parent = parent;
    }

    public void m_7856_() {
        super.m_7856_();
        CompletableFuture.runAsync(FriendUpdateThread::updateFriendsList);
        this.list = new ScreenList((Screen)this, this.f_96541_, 100, this.f_96544_ - 90, 32, this.f_96544_ - 55, 28, 100);
        this.list.m_93507_(18);
        this.chat = new ScrollingChat(this, this.f_96543_ - this.list.m_5759_() - 40, this.f_96544_ - 90, 32, this.f_96544_ - 55, 125, true);
        this.chat.m_93507_(this.list.m_93520_());
        this.chatBox = new EditBox(this.f_96547_, this.list.m_93520_() + 1, this.f_96544_ - 50, this.chat.getWidth() - 2, 20, (Component)new TranslatableComponent(""));
        this.chatBox.m_94199_(256);
        this.searchEntry = new EditBox(this.f_96547_, 19, this.f_96544_ - 50, this.list.width - 2, 20, (Component)new TranslatableComponent(""));
        this.searchEntry.m_94167_(I18n.m_118938_((String)"minetogether.search", (Object[])new Object[0]));
        this.m_7787_((GuiEventListener)this.list);
        this.m_7787_((GuiEventListener)this.searchEntry);
        this.m_7787_((GuiEventListener)this.chatBox);
        this.m_7787_((GuiEventListener)this.chat);
        this.addButtons();
        this.refreshFriendsList();
    }

    public void addButtons() {
        this.m_142416_((GuiEventListener)new Button(5, this.f_96544_ - 26, 100, 20, (Component)new TranslatableComponent("Cancel"), p -> this.f_96541_.m_91152_(this.parent)));
        this.friendCodeButton = new ButtonString(this.f_96543_ - 105, 5, 120, 20, (Component)new TranslatableComponent(MineTogetherChat.profile.get().getFriendCode()), p -> {
            this.f_96541_.f_91068_.m_90911_(MineTogetherChat.profile.get().getFriendCode());
            SimpleToast simpleToast = new SimpleToast((Component)new TextComponent("Copied to clipboard."), (Component)new TextComponent(" "), Constants.MINETOGETHER_LOGO_LOCATION);
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)simpleToast);
        });
        this.m_142416_((GuiEventListener)this.friendCodeButton);
        this.removeFriend = new ButtonMultiple(this.f_96543_ - 20, 32, 5, Constants.WIDGETS_LOCATION, (Component)new TranslatableComponent("minetogether.friendscreen.tooltip.removebutton"), button -> this.removeFriend(this.targetProfile));
        this.m_142416_((GuiEventListener)this.removeFriend);
        this.blockButton = new ButtonMultiple(this.f_96543_ - 20, 52, 6, Constants.WIDGETS_LOCATION, (Component)new TranslatableComponent("minetogether.friendscreen.tooltip.block"), button -> ChatModule.muteUser(this.targetProfile.getLongHash()));
        this.m_142416_((GuiEventListener)this.blockButton);
        this.partyButton = new ButtonMultiple(this.f_96543_ - 20, 72, 7, Constants.WIDGETS_LOCATION, (Component)new TranslatableComponent("minetogether.friendscreen.tooltip.partytime"), button -> ChatHandler.sendPartyInvite(this.targetProfile.getMediumHash(), MineTogetherChat.profile.get().getMediumHash()));
        this.m_142416_((GuiEventListener)this.partyButton);
        this.editButton = new ButtonMultiple(this.f_96543_ - 20, 92, 8, Constants.WIDGETS_LOCATION, (Component)new TranslatableComponent("minetogether.friendscreen.tooltip.editbutton"), button -> {
            try {
                this.f_96541_.m_91152_((Screen)new FriendRequestScreen(this, this.f_96541_.m_91094_().m_92546_(), this.targetProfile, ChatCallbacks.getFriendCode(MineTogetherClient.getPlayerHash()), this.targetProfile.getFriendName(), false, true));
            }
            catch (IOException e) {
                Sentry.captureException(e);
            }
        });
        this.m_142416_((GuiEventListener)this.editButton);
        this.mutedList = new Button(5, 5, 100, 20, (Component)new TranslatableComponent("Muted List"), p -> this.f_96541_.m_91152_((Screen)new MutedListScreen(this)));
        this.m_142416_((GuiEventListener)this.mutedList);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        this.m_96626_(1);
        this.list.m_6305_(poseStack, i, j, f);
        this.searchEntry.m_6305_(poseStack, i, j, f);
        this.chatBox.m_6305_(poseStack, i, j, f);
        this.chat.m_6305_(poseStack, i, j, f);
        super.m_6305_(poseStack, i, j, f);
        FriendsListScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)12, (int)0xFFFFFF);
        if (this.list.m_6702_().isEmpty()) {
            FriendsListScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("minetogether.friendslist.empty"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 20), (int)-1);
        }
        if (this.friendCodeButton != null && this.friendCodeButton.m_198029_()) {
            this.m_96602_(poseStack, (Component)new TranslatableComponent("minetogether.friendslist.copytoclipboard"), i, j);
        }
        this.renderTooltips(poseStack, i, j, f);
    }

    public void m_96624_() {
        ++this.ticks;
        if (this.ticks % 600 == 0) {
            this.refreshFriendsList();
        }
        if (this.targetProfile != null) {
            this.partyButton.f_93623_ = this.targetProfile.isOnline();
        }
        if (this.list.getCurrSelected() != null && this.targetProfile != null && !this.targetProfile.equals(((ListEntryFriend)this.list.getCurrSelected()).getProfile())) {
            this.targetProfile = ((ListEntryFriend)this.list.getCurrSelected()).getProfile();
            this.chat.updateLines(this.targetProfile.getMediumHash());
        }
        if (this.targetProfile != null) {
            this.chatBox.m_94167_(this.targetProfile.isOnline() ? "" : "Friend is offline");
            this.chatBox.m_94186_(this.targetProfile.isOnline());
            if (ChatHandler.hasNewMessages(this.targetProfile.getMediumHash())) {
                this.chat.updateLines(this.targetProfile.getMediumHash());
                ChatHandler.setMessagesRead(this.targetProfile.getMediumHash());
            }
        }
        this.toggleInteractionButtons(this.list.getCurrSelected() != null);
    }

    public void toggleInteractionButtons(boolean value) {
        this.removeFriend.f_93623_ = value;
        this.blockButton.f_93623_ = value;
        this.editButton.f_93623_ = value;
        if (this.targetProfile == null) {
            this.partyButton.f_93623_ = value;
        }
    }

    protected boolean refreshFriendsList() {
        List<Profile> friendsRet = KnownUsers.getFriends();
        if (friendsRet == null) {
            return false;
        }
        ArrayList friends = new ArrayList();
        List onlineFriends = friendsRet.stream().filter(Profile::isOnline).collect(Collectors.toList());
        onlineFriends.sort(NameComparator.INSTANCE);
        List offlineFriends = friendsRet.stream().filter(profile -> !profile.isOnline()).collect(Collectors.toList());
        offlineFriends.sort(NameComparator.INSTANCE);
        friends.addAll(onlineFriends);
        friends.addAll(offlineFriends);
        this.list.clearList();
        if (friends != null) {
            for (Profile friendProfile : friends) {
                ListEntryFriend friendEntry = new ListEntryFriend(this, this.list, friendProfile);
                if (this.searchEntry != null && !this.searchEntry.m_94155_().isEmpty()) {
                    String s = this.searchEntry.m_94155_();
                    if (friendProfile.friendName.toLowerCase().contains(s.toLowerCase()) && !removedFriends.contains(friendProfile)) {
                        this.list.add((ScreenListEntry)friendEntry);
                    }
                } else if (!removedFriends.contains(friendProfile)) {
                    this.list.add((ScreenListEntry)friendEntry);
                }
                if (this.targetProfile == null || !friendProfile.getFriendName().equals(this.targetProfile.getFriendName())) continue;
                this.list.m_6987_((AbstractSelectionList.Entry)friendEntry);
            }
            ArrayList<Profile> removedCopy = new ArrayList<Profile>(removedFriends);
            for (Profile removed : removedCopy) {
                boolean isInList = false;
                for (Profile friend : friends) {
                    if (!friend.friendCode.equalsIgnoreCase(removed.friendCode)) continue;
                    isInList = true;
                    break;
                }
                if (isInList) continue;
                removedFriends.remove(removed);
            }
        }
        return true;
    }

    public void removeFriend(Profile profile) {
        ConfirmScreen confirmScreen = new ConfirmScreen(t -> {
            if (t) {
                CompletableFuture.runAsync(() -> {
                    removedFriends.add(profile);
                    this.refreshFriendsList();
                    try {
                        if (!ChatCallbacks.removeFriend(profile.getFriendCode(), MineTogetherClient.getPlayerHash())) {
                            profile.setFriend(false);
                            this.refreshFriendsList();
                        }
                    }
                    catch (IOException e) {
                        Sentry.captureException(e);
                    }
                });
            }
            this.f_96541_.m_91152_((Screen)new FriendsListScreen(this.parent));
        }, (Component)new TranslatableComponent("minetogether.removefriend.sure1"), (Component)new TranslatableComponent("minetogether.removefriend.sure2"));
        this.f_96541_.m_91152_((Screen)confirmScreen);
    }

    public boolean m_5534_(char c, int i) {
        if (this.searchEntry.m_93696_()) {
            boolean flag = this.searchEntry.m_5534_(c, i);
            this.refreshFriendsList();
            return flag;
        }
        if (this.chatBox.m_93696_()) {
            return this.chatBox.m_5534_(c, i);
        }
        return super.m_5534_(c, i);
    }

    public boolean m_7933_(int i, int j, int k) {
        if (this.searchEntry.m_93696_()) {
            this.searchEntry.m_94167_("");
            boolean flag = this.searchEntry.m_7933_(i, j, k);
            this.refreshFriendsList();
            return flag;
        }
        if (this.targetProfile != null && this.chatBox.m_93696_()) {
            if (!(i != 257 && i != 335 || this.chatBox.m_94155_().trim().isEmpty())) {
                ChatHandler.sendMessage(this.targetProfile.getMediumHash(), ChatFormatter.getStringForSending(this.chatBox.m_94155_()));
                this.chatBox.m_94144_("");
            }
            return this.chatBox.m_7933_(i, j, k);
        }
        return super.m_7933_(i, j, k);
    }

    public boolean m_6375_(double d, double e, int i) {
        return super.m_6375_(d, e, i);
    }

    public boolean m_6348_(double d, double e, int i) {
        if (this.list.m_5953_(d, e) && this.list.getCurrSelected() != null) {
            boolean flag;
            if (this.list.getCurrSelected() == null) {
                return super.m_6348_(d, e, i);
            }
            boolean bl = flag = this.targetProfile == null || !this.targetProfile.equals(((ListEntryFriend)this.list.getCurrSelected()).getProfile());
            if (flag) {
                Profile profile = ((ListEntryFriend)this.list.getCurrSelected()).getProfile();
                if (profile != null && profile.isFriend()) {
                    this.targetProfile = profile;
                    this.chat.updateLines(profile.getMediumHash());
                }
                return flag;
            }
        }
        return super.m_6348_(d, e, i);
    }

    public static class NameComparator
    implements Comparator<Profile> {
        public static final NameComparator INSTANCE = new NameComparator();

        @Override
        public int compare(Profile profile1, Profile profile2) {
            String str1 = profile1.friendName;
            String str2 = profile2.friendName;
            int res = String.CASE_INSENSITIVE_ORDER.compare(str1, str2);
            if (res == 0) {
                res = str1.compareTo(str2);
            }
            return res;
        }
    }
}

