/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.io.sentry.Sentry;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class FriendRequestScreen
extends Screen {
    private final String playerName;
    private final String chatInternalName;
    private final String friendCode;
    private final boolean accept;
    private final boolean update;
    private final String friendName;
    private final Screen parent;
    private Profile profile;
    private Button acceptBtn;
    private Button cancelBtn;
    boolean first = true;
    private EditBox nameEntry;
    Minecraft mc = Minecraft.m_91087_();

    public FriendRequestScreen(Screen parent, String playerName, Profile friendTarget, String friendCode, String friendName, boolean accept, boolean update) {
        super((Component)new TranslatableComponent(""));
        this.playerName = playerName;
        this.chatInternalName = friendTarget == null ? "" : friendTarget.getCurrentIRCNick();
        this.friendCode = friendCode;
        this.accept = accept;
        this.parent = parent;
        this.friendName = friendName;
        this.profile = friendTarget;
        this.update = update;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.mc.f_91068_.m_90926_(true);
        this.cancelBtn = new Button(this.f_96543_ / 2 - 180, this.f_96544_ - 50, 80, 20, (Component)new TranslatableComponent("Cancel"), button -> Minecraft.m_91087_().m_91152_(this.parent));
        this.m_142416_((GuiEventListener)this.cancelBtn);
        this.acceptBtn = new Button(this.f_96543_ / 2 + 100, this.f_96544_ - 50, 80, 20, (Component)(this.accept ? new TranslatableComponent("Accept") : new TranslatableComponent("Send request")), buttons -> {
            if (this.update) {
                try {
                    ChatCallbacks.removeFriend(this.friendCode, MineTogetherClient.getPlayerHash());
                }
                catch (IOException e) {
                    Sentry.captureException(e);
                }
                CompletableFuture.runAsync(() -> {
                    try {
                        ChatCallbacks.addFriend(this.friendCode, this.nameEntry.m_94155_().trim(), MineTogetherClient.getPlayerHash());
                    }
                    catch (IOException e) {
                        Sentry.captureException(e);
                    }
                }, MineTogetherChat.otherExecutor);
                Minecraft.m_91087_().m_91152_(this.parent);
                return;
            }
            if (this.accept) {
                ChatHandler.acceptFriendRequest(this.chatInternalName, this.friendName);
                CompletableFuture.runAsync(() -> {
                    try {
                        ChatCallbacks.addFriend(this.friendCode, this.nameEntry.m_94155_().trim(), MineTogetherClient.getPlayerHash());
                    }
                    catch (IOException e) {
                        Sentry.captureException(e);
                    }
                }, MineTogetherChat.otherExecutor);
            } else {
                ChatHandler.sendFriendRequest(this.chatInternalName, this.nameEntry.m_94155_().trim());
            }
            Minecraft.m_91087_().m_91152_(this.parent);
        });
        this.m_142416_((GuiEventListener)this.acceptBtn);
        this.nameEntry = new EditBox(this.mc.f_91062_, this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 10, 200, 20, (Component)new TranslatableComponent(""));
        this.m_142416_((GuiEventListener)this.nameEntry);
        if (this.first) {
            String name = !this.profile.getFriendName().isEmpty() ? this.profile.getFriendName() : this.profile.getUserDisplay();
            this.nameEntry.m_94144_(name);
            this.first = false;
        }
        this.acceptBtn.f_93623_ = this.nameEntry.m_94155_().trim().length() >= 3;
        this.nameEntry.m_94178_(true);
        this.nameEntry.m_94190_(false);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(1);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.nameEntry.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        FriendRequestScreen.m_93208_((PoseStack)matrixStack, (Font)this.mc.f_91062_, (String)(this.accept ? I18n.m_118938_((String)"minetogether.friend.acceptgui", (Object[])new Object[0]) : I18n.m_118938_((String)"minetogether.friend.addgui", (Object[])new Object[0])), (int)(this.f_96543_ / 2), (int)5, (int)-1);
        FriendRequestScreen.m_93208_((PoseStack)matrixStack, (Font)this.mc.f_91062_, (String)(this.accept ? I18n.m_118938_((String)"minetogether.friend.acceptname", (Object[])new Object[0]) : I18n.m_118938_((String)"minetogether.friend.addname", (Object[])new Object[0])), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 30), (int)-1);
    }
}

