/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.MineTogetherCommon;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.io.sentry.Sentry;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatConnectionStatus;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.lib.chat.irc.IrcHandler;
import net.creeperhost.minetogether.module.chat.ChatFormatter;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.module.chat.ScrollingChat;
import net.creeperhost.minetogether.module.chat.Target;
import net.creeperhost.minetogether.module.chat.screen.FriendRequestScreen;
import net.creeperhost.minetogether.module.chat.screen.FriendsListScreen;
import net.creeperhost.minetogether.screen.MineTogetherScreen;
import net.creeperhost.minetogether.screen.SettingsScreen;
import net.creeperhost.polylib.client.screen.widget.buttons.ButtonMultiple;
import net.creeperhost.polylib.client.screen.widget.buttons.ButtonNoBlend;
import net.creeperhost.polylib.client.screen.widget.buttons.ButtonString;
import net.creeperhost.polylib.client.screen.widget.buttons.DropdownButton;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.Nullable;

public class ChatScreen
extends MineTogetherScreen {
    private final Screen parent;
    private ScrollingChat chat;
    private EditBox send;
    private String currentTarget = ChatHandler.CHANNEL;
    private ButtonString connectionStatus;
    public DropdownButton<Target> targetDropdownButton;
    private DropdownButton<Menu> menuDropdownButton;
    private String activeDropdown;
    private Button newUserButton;
    private Button disableButton;
    private Button friendsList;

    public ChatScreen(Screen parent) {
        super((Component)new TranslatableComponent("MineTogether Chat"));
        this.parent = parent;
    }

    public ChatScreen(Screen parent, String currentTarget) {
        super((Component)new TranslatableComponent("MineTogether Chat"));
        this.parent = parent;
        this.currentTarget = currentTarget;
    }

    public void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.chat = new ScrollingChat(this, this.f_96543_, this.f_96544_, 13);
        this.chat.m_93507_(10);
        this.chat.updateLines(this.currentTarget);
        this.send = new EditBox(this.f_96541_.f_91062_, 11, this.f_96544_ - 48, this.f_96543_ - 22, 20, (Component)new TranslatableComponent(""));
        this.send.m_94178_(true);
        this.send.m_94199_(256);
        this.addButtons();
        super.m_7856_();
    }

    public void addButtons() {
        this.targetDropdownButton = new DropdownButton(this.f_96543_ - 5 - 100, 5, 100, 20, (Component)new TranslatableComponent("Chat: %s"), (DropdownButton.IDropdownOption)Target.getMainTarget(), true, p -> {
            if (!this.targetDropdownButton.dropdownOpen) {
                return;
            }
            if (!((Target)this.targetDropdownButton.getSelected()).getInternalTarget().equals(this.currentTarget)) {
                this.currentTarget = ((Target)this.targetDropdownButton.getSelected()).getInternalTarget();
            }
            this.chat.updateLines(this.currentTarget);
            this.targetDropdownButton.wasJustClosed = false;
            this.targetDropdownButton.dropdownOpen = false;
        });
        this.m_142416_((GuiEventListener)this.targetDropdownButton);
        this.targetDropdownButton.setSelected((DropdownButton.IDropdownOption)Target.getMainTarget());
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(I18n.m_118938_((String)"minetogether.chat.button.mute", (Object[])new Object[0]));
        strings.add(I18n.m_118938_((String)"minetogether.chat.button.addfriend", (Object[])new Object[0]));
        strings.add(I18n.m_118938_((String)"minetogether.chat.button.mention", (Object[])new Object[0]));
        this.menuDropdownButton = new DropdownButton(-1000, -1000, 100, 20, (Component)new TranslatableComponent("Menu"), (DropdownButton.IDropdownOption)new Menu(strings), false, p -> {
            if (!this.menuDropdownButton.dropdownOpen) {
                return;
            }
            if (((Menu)this.menuDropdownButton.getSelected()).option.equalsIgnoreCase(I18n.m_118938_((String)"minetogether.chat.button.mute", (Object[])new Object[0]))) {
                Profile profile = KnownUsers.findByDisplay(this.activeDropdown);
                if (profile != null) {
                    ChatModule.muteUser(KnownUsers.findByDisplay((String)this.activeDropdown).longHash);
                    KnownUsers.findByDisplay(this.activeDropdown).setMuted(true);
                    ChatHandler.addStatusMessage("Locally blocked " + this.activeDropdown);
                }
            } else if (((Menu)this.menuDropdownButton.getSelected()).option.equalsIgnoreCase(I18n.m_118938_((String)"minetogether.chat.button.addfriend", (Object[])new Object[0]))) {
                try {
                    this.f_96541_.m_91152_((Screen)new FriendRequestScreen(new ChatScreen(this.parent), Minecraft.m_91087_().m_91094_().m_92546_(), KnownUsers.findByDisplay(this.activeDropdown), ChatCallbacks.getFriendCode(MineTogetherClient.getPlayerHash()), "", false, false));
                }
                catch (IOException e) {
                    Sentry.captureException(e);
                }
            } else if (((Menu)this.menuDropdownButton.getSelected()).option.equalsIgnoreCase(I18n.m_118938_((String)"minetogether.chat.button.mention", (Object[])new Object[0]))) {
                this.send.m_94178_(true);
                this.send.m_94144_(this.send.m_94155_() + " " + this.activeDropdown + " ");
            }
            this.menuDropdownButton.f_93621_ = -10000;
            this.menuDropdownButton.f_93620_ = -10000;
            this.menuDropdownButton.wasJustClosed = false;
            this.menuDropdownButton.dropdownOpen = false;
        }, false);
        this.m_142416_((GuiEventListener)this.menuDropdownButton);
        this.friendsList = new Button(5, 5, 100, 20, (Component)new TranslatableComponent("Friends list"), p -> this.f_96541_.m_91152_((Screen)new FriendsListScreen(this)));
        this.m_142416_((GuiEventListener)this.friendsList);
        this.m_142416_((GuiEventListener)new ButtonMultiple(this.f_96543_ - 124, 5, 3, Constants.WIDGETS_LOCATION, p -> this.f_96541_.m_91152_((Screen)new SettingsScreen(this))));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 100 - 5, this.f_96544_ - 5 - 20, 100, 20, (Component)new TranslatableComponent("Cancel"), p -> this.f_96541_.m_91152_(this.parent)));
        this.connectionStatus = new ButtonString(8, this.f_96544_ - 20, 70, 20, () -> {
            ChatConnectionStatus status = ChatHandler.connectionStatus;
            return new TranslatableComponent(ChatFormatting.m_126657_((String)status.colour) + "\u2022 " + ChatFormatting.WHITE + status.display);
        }, ButtonString.RenderPlace.EXACT, button -> {
            if (ChatHandler.connectionStatus == ChatConnectionStatus.BANNED) {
                ConfirmScreen confirmScreen = new ConfirmScreen(t -> {
                    if (t) {
                        try {
                            Util.m_137581_().m_137650_(new URL("https://minetogether.io/profile/standing"));
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                    this.f_96541_.m_91152_((Screen)this);
                }, (Component)new TranslatableComponent("minetogether.bannedscreen.line1"), (Component)new TranslatableComponent("minetogether.bannedscreen.line2"));
                this.f_96541_.m_91152_((Screen)confirmScreen);
            }
        });
        this.m_142416_((GuiEventListener)this.connectionStatus);
        if (Config.getInstance().getFirstConnect()) {
            ChatCallbacks.updateOnlineCount();
            this.newUserButton = new ButtonNoBlend(this.f_96543_ / 2 - 150, 75 + this.f_96544_ / 4, 300, 20, (Component)new TranslatableComponent("Join " + ChatCallbacks.onlineCount + " online users now!"), p -> {
                IrcHandler.sendCTCPMessage("Freddy", "ACTIVE", "");
                Config.getInstance().setFirstConnect(false);
                Config.saveConfigToFile(MineTogetherCommon.configFile.toFile());
                this.newUserButton.f_93624_ = false;
                this.disableButton.f_93624_ = false;
                this.f_96541_.m_91152_((Screen)this);
            });
            this.m_142416_((GuiEventListener)this.newUserButton);
            this.disableButton = new ButtonNoBlend(this.f_96543_ / 2 - 150, 95 + this.f_96544_ / 4, 300, 20, (Component)new TranslatableComponent("Don't ask me again"), p -> {
                Config.getInstance().setChatEnabled(false);
                Config.saveConfigToFile(MineTogetherCommon.configFile.toFile());
                this.disableButton.f_93624_ = false;
                this.newUserButton.f_93624_ = false;
                IrcHandler.stop(true);
                this.m_169413_();
                this.f_96541_.m_91152_(this.parent);
            });
            this.m_142416_((GuiEventListener)this.disableButton);
        }
        IrcHandler.sendCTCPMessage("Freddy", "ACTIVE", "");
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(1);
        this.renderConnectionStatus();
        this.chat.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.menuDropdownButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.send.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        ChatScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)5, (int)0xFFFFFF);
        if (Config.getInstance().getFirstConnect()) {
            ChatScreen.m_93172_((PoseStack)poseStack, (int)10, (int)this.chat.getTop(), (int)(this.f_96543_ - 10), (int)this.chat.getHeight(), (int)-1728053248);
            ChatScreen.m_93172_((PoseStack)poseStack, (int)10, (int)this.chat.getTop(), (int)(this.f_96543_ - 10), (int)this.chat.getHeight(), (int)-1728053248);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            ChatScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Welcome to MineTogether", (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 4 + 25), (int)0xFFFFFF);
            ChatScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"MineTogether is a multiplayer enhancement mod that provides", (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 4 + 35), (int)0xFFFFFF);
            ChatScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"a multitude of features like chat, friends list, server listing", (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 4 + 45), (int)0xFFFFFF);
            ChatScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)("and more. Join " + ChatCallbacks.userCount + " unique users."), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 4 + 55), (int)0xFFFFFF);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public void renderConnectionStatus() {
        ChatConnectionStatus chatConnectionStatus = ChatHandler.connectionStatus;
        TranslatableComponent comp = new TranslatableComponent(ChatFormatting.m_126657_((String)chatConnectionStatus.colour) + "\u2022 " + ChatFormatting.WHITE + chatConnectionStatus.display);
        this.connectionStatus.m_93666_((Component)comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_96624_() {
        this.chat.tick();
        String buttonTarget = ((Target)this.targetDropdownButton.getSelected()).getInternalTarget();
        if (!buttonTarget.equals(this.currentTarget)) {
            this.currentTarget = buttonTarget;
        }
        this.friendsList.f_93623_ = !Config.getInstance().getFirstConnect();
        this.targetDropdownButton.f_93623_ = !Config.getInstance().getFirstConnect();
        this.send.f_93623_ = ChatHandler.connectionStatus == ChatConnectionStatus.VERIFIED;
        this.send.m_94186_(ChatHandler.connectionStatus == ChatConnectionStatus.VERIFIED);
        if (this.send.m_93696_() && ChatHandler.connectionStatus != ChatConnectionStatus.VERIFIED) {
            this.send.m_94178_(false);
        }
        switch (ChatHandler.connectionStatus) {
            case VERIFYING: {
                this.send.m_94167_(I18n.m_118938_((String)"minetogether.chat.message.unverified", (Object[])new Object[0]));
                break;
            }
            case BANNED: {
                this.send.m_94167_(I18n.m_118938_((String)"minetogether.chat.message.banned", (Object[])new Object[0]));
                break;
            }
            case DISCONNECTED: {
                this.send.m_94167_(I18n.m_118938_((String)"minetogether.chat.message.disconnect", (Object[])new Object[0]));
                break;
            }
            case CONNECTING: {
                this.send.m_94167_(I18n.m_118938_((String)"minetogether.chat.message.connecting", (Object[])new Object[0]));
                break;
            }
            case VERIFIED: {
                this.send.m_94167_("");
            }
        }
        Object object = ChatHandler.ircLock;
        synchronized (object) {
            if (ChatHandler.hasNewMessages(this.currentTarget)) {
                this.chat.updateLines(this.currentTarget);
                ChatHandler.setMessagesRead(this.currentTarget);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (super.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.send.m_6375_(mouseX, mouseY, mouseButton)) {
            this.menuDropdownButton.f_93621_ = -10000;
            this.menuDropdownButton.f_93620_ = -10000;
            this.menuDropdownButton.wasJustClosed = false;
            this.menuDropdownButton.dropdownOpen = false;
            return true;
        }
        if (this.menuDropdownButton.wasJustClosed && !this.menuDropdownButton.dropdownOpen) {
            this.menuDropdownButton.f_93621_ = -10000;
            this.menuDropdownButton.f_93620_ = -10000;
            this.menuDropdownButton.wasJustClosed = false;
        }
        this.chat.m_6375_(mouseX, mouseY, mouseButton);
        return false;
    }

    public boolean m_7979_(double d, double e, int i, double f, double g) {
        this.chat.m_7979_(d, e, i, f, g);
        return super.m_7979_(d, e, i, f, g);
    }

    public boolean m_6050_(double d, double e, double f) {
        this.chat.m_6050_(d, e, f);
        return super.m_6050_(d, e, f);
    }

    @Deprecated
    public void rebuildChat() {
        double scroll = this.chat.m_93517_();
        this.chat.updateLines(this.currentTarget);
        this.chat.m_93410_(scroll);
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!(p_keyPressed_1_ != 257 && p_keyPressed_1_ != 335 || this.send.m_94155_().trim().isEmpty())) {
            ChatHandler.sendMessage(this.currentTarget, ChatFormatter.getStringForSending(this.send.m_94155_()));
            this.send.m_94144_("");
        }
        this.send.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_5534_(char c, int i) {
        this.send.m_5534_(c, i);
        return super.m_5534_(c, i);
    }

    @Override
    public boolean handleComponentClicked(@Nullable Style style, double mouseX, double mouseY) {
        if (this.newUserButton != null && this.newUserButton.f_93624_) {
            return false;
        }
        if (style == null) {
            return false;
        }
        if (style.m_131182_() == null) {
            return false;
        }
        ClickEvent event = style.m_131182_();
        if (event == null) {
            return false;
        }
        if (event.m_130622_() == ClickEvent.Action.SUGGEST_COMMAND) {
            String eventValue = event.m_130623_();
            if (eventValue.contains(":")) {
                String[] split = eventValue.split(":");
                if (split.length < 3) {
                    return false;
                }
                String chatInternalName = split[1];
                String friendCode = split[2];
                StringBuilder builder = new StringBuilder();
                for (int i = 3; i < split.length; ++i) {
                    builder.append(split[i]).append(" ");
                }
                String friendName = builder.toString().trim();
                Profile targetProfile = KnownUsers.findByNick(chatInternalName);
                if (targetProfile == null) {
                    targetProfile = KnownUsers.add(chatInternalName);
                }
                Minecraft.m_91087_().m_91152_((Screen)new FriendRequestScreen(this, Minecraft.m_91087_().m_91094_().m_92546_(), targetProfile, friendCode, friendName, true, false));
                return true;
            }
            this.menuDropdownButton.f_93620_ = (int)mouseX;
            this.menuDropdownButton.f_93621_ = (int)mouseY;
            boolean bl = this.menuDropdownButton.flipped = mouseY > 150.0;
            if (!this.menuDropdownButton.flipped) {
                this.menuDropdownButton.f_93621_ -= this.menuDropdownButton.m_93694_() - 1;
                ++this.menuDropdownButton.f_93620_;
            }
            this.menuDropdownButton.dropdownOpen = true;
            this.activeDropdown = event.m_130623_();
            return true;
        }
        if (event.m_130622_() == ClickEvent.Action.OPEN_URL) {
            this.m_5561_(style);
        }
        return false;
    }

    public static class Menu
    implements DropdownButton.IDropdownOption {
        List<DropdownButton.IDropdownOption> possibleValsCache;
        public String option;

        public Menu(List<String> options) {
            this.possibleValsCache = new ArrayList<DropdownButton.IDropdownOption>();
            this.possibleValsCache.add(this);
            this.option = options.get(0);
            options.remove(0);
            for (String option : options) {
                this.possibleValsCache.add(new Menu(this.possibleValsCache, option));
            }
        }

        public Menu(List<DropdownButton.IDropdownOption> vals, String option) {
            this.possibleValsCache = vals;
            this.option = option;
        }

        public String getTranslate(DropdownButton.IDropdownOption current, boolean dropdownOpen) {
            return this.option;
        }

        public List<DropdownButton.IDropdownOption> getPossibleVals() {
            return this.possibleValsCache;
        }
    }
}

