/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat.screen;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.io.sentry.Sentry;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.IChatListener;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Message;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.module.chat.ChatFormatter;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.polylib.client.toast.SimpleToast;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ChatListener
implements IChatListener {
    public static ChatListener INSTANCE = new ChatListener();

    @Override
    public void onPartyInvite(Profile profile) {
        SimpleToast simpleToast = new SimpleToast((Component)new TextComponent("New party invite from "), (Component)new TextComponent(profile.getFriendName()), Constants.MINETOGETHER_LOGO_LOCATION);
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)simpleToast);
    }

    @Override
    public void onFriendOnline(Profile profile) {
        SimpleToast simpleToast = new SimpleToast((Component)new TextComponent(profile.getFriendName() + " Is now online"), (Component)new TextComponent(" "), Constants.MINETOGETHER_LOGO_LOCATION);
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)simpleToast);
    }

    @Override
    public void onFriendAccept(String name, String data) {
        SimpleToast simpleToast = new SimpleToast((Component)new TextComponent(name + " Has accepted your friend request"), (Component)new TextComponent(" "), Constants.MINETOGETHER_LOGO_LOCATION);
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)simpleToast);
        ChatHandler.addMessageToChat(ChatHandler.CHANNEL, "FA:" + name, data);
        Profile profile = KnownUsers.findByNick(name);
        if (profile != null) {
            CompletableFuture.runAsync(() -> {
                try {
                    ChatCallbacks.addFriend(profile.getFriendCode(), data, MineTogetherClient.getPlayerHash());
                }
                catch (IOException e) {
                    Sentry.captureException(e);
                }
            }, MineTogetherChat.otherExecutor);
        }
    }

    @Override
    public void onFriendRequest(String user, String data) {
        SimpleToast simpleToast = new SimpleToast((Component)new TextComponent(user + " Has sent you a friend request"), (Component)new TextComponent(" "), Constants.MINETOGETHER_LOGO_LOCATION);
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)simpleToast);
        ChatHandler.addMessageToChat(ChatHandler.CHANNEL, "FR:" + user, data);
    }

    @Override
    public String onServerIdRequest() {
        return MineTogetherClient.getServerIDAndVerify();
    }

    @Override
    public void sendMessage(String channel, Message message) {
        ChatModule.sendMessage(channel, ChatFormatter.formatLine(message));
    }

    @Override
    public void setHasNewMessage(boolean value) {
        ChatModule.hasNewMessage = value;
    }

    @Override
    public String getVerifyOutput() {
        return MineTogetherChat.INSTANCE.signature + ":" + MineTogetherClient.getUUID() + ":" + MineTogetherClient.getServerIDAndVerify();
    }
}

