/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.io.sentry.Sentry;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.data.Message;
import net.creeperhost.minetogether.lib.util.LimitedSizeQueue;
import net.creeperhost.minetogether.module.chat.ChatFormatter;
import net.creeperhost.minetogether.screen.MineTogetherScreen;
import net.creeperhost.minetogether.util.ComponentUtils;
import net.creeperhost.polylib.client.gif.AnimatedGif;
import net.creeperhost.polylib.client.gif.ImageRenderer;
import net.creeperhost.polylib.client.gif.ImageUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ScrollingChat
extends ObjectSelectionList {
    private ArrayList<FormattedCharSequence> lines;
    private final int height;
    private final int top;
    private final int bottom;
    private final int itemHeight;
    private final MineTogetherScreen screen;
    private final int chatOffset;
    private final boolean renderBackground;
    private AnimatedGif gifImage;
    private AnimatedGif.GifPlayer gifPlayer;
    private ImageRenderer.Image image;
    private ImageRenderer imageRenderer;

    public ScrollingChat(MineTogetherScreen screen, int width, int height, int chatOffset) {
        super(Minecraft.m_91087_(), width - 20, height - 50, 30, height - 50, 10);
        this.height = height - 50;
        this.f_93388_ = width - 20;
        this.top = 30;
        this.bottom = height - 50;
        this.itemHeight = 10;
        this.chatOffset = chatOffset;
        this.screen = screen;
        this.lines = new ArrayList();
        this.renderBackground = true;
    }

    public ScrollingChat(MineTogetherScreen screen, int widthIn, int heightIn, int topIn, int bottomIn, int chatOffset, boolean renderBackground) {
        super(Minecraft.m_91087_(), widthIn, heightIn, topIn, bottomIn, 10);
        this.height = heightIn;
        this.f_93388_ = widthIn;
        this.top = 30;
        this.bottom = this.height;
        this.itemHeight = 10;
        this.screen = screen;
        this.lines = new ArrayList();
        this.chatOffset = chatOffset;
        this.renderBackground = renderBackground;
    }

    public void renderEntry(PoseStack poseStack, int index, int mouseX, int mouseY, float partialTicks) {
        try {
            int totalWidth;
            FormattedCharSequence component = this.lines.get(index);
            int oldTotal = totalWidth = this.chatOffset;
            boolean hovering = mouseX > oldTotal && mouseX < (totalWidth += this.f_93386_.f_91062_.m_92724_(component)) && mouseY > this.m_7610_(index) && mouseY < this.m_7610_(index) + this.itemHeight;
            Style style = this.f_93386_.f_91062_.m_92865_().m_92338_(component, mouseX);
            if (hovering) {
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
                this.f_93386_.f_91062_.m_92877_(poseStack, component, (float)oldTotal, (float)this.m_7610_(index), -1140850689);
                this.screen.m_96570_(poseStack, style, mouseX, mouseY);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (style.m_131186_() != null && style.m_131186_().m_130820_() == ComponentUtils.RENDER_GIF) {
                    Component urlComponent = (Component)style.m_131186_().m_130823_(ComponentUtils.RENDER_GIF);
                    String url = urlComponent.getString();
                    if (ImageUtils.getContentType((URL)new URL(url)).equals("image/gif")) {
                        if (this.gifImage == null) {
                            CompletableFuture.runAsync(() -> {
                                try {
                                    this.gifImage = AnimatedGif.fromURL((URL)new URL(url));
                                }
                                catch (IOException exception) {
                                    exception.printStackTrace();
                                }
                            }, AnimatedGif.GIF_EXECUTOR);
                        }
                        if (this.gifPlayer == null) {
                            this.gifPlayer = this.gifImage.makeGifPlayer();
                            this.gifPlayer.setAutoplay(true);
                            this.gifPlayer.setLooping(true);
                        }
                    } else {
                        if (this.image == null) {
                            CompletableFuture.runAsync(() -> {
                                try {
                                    this.image = ImageRenderer.fromURL((URL)new URL(url));
                                }
                                catch (IOException exception) {
                                    exception.printStackTrace();
                                }
                            }, AnimatedGif.GIF_EXECUTOR);
                        }
                        if (this.image != null && this.imageRenderer == null) {
                            this.imageRenderer = new ImageRenderer(this.image);
                        }
                    }
                } else {
                    this.imageRenderer = null;
                    this.image = null;
                    this.gifImage = null;
                    this.gifPlayer = null;
                }
            } else {
                this.f_93386_.f_91062_.m_92877_(poseStack, component, (float)oldTotal, (float)this.m_7610_(index), 0xFFFFFF);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int m_5773_() {
        return this.lines.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLines(String key) {
        LimitedSizeQueue<Message> tempMessages;
        int oldMaxScroll = this.m_93518_();
        Object object = ChatHandler.ircLock;
        synchronized (object) {
            if (ChatHandler.messages == null || ChatHandler.messages.size() == 0) {
                return;
            }
            tempMessages = ChatHandler.messages.get(key);
        }
        ArrayList<FormattedCharSequence> oldLines = this.lines;
        int listHeight = this.height - (this.bottom - this.top - 4);
        this.lines = new ArrayList();
        if (tempMessages == null) {
            return;
        }
        try {
            for (Message message : tempMessages) {
                Component display = ChatFormatter.formatLine(message);
                if (display == null) continue;
                this.lines.addAll(ComponentRenderUtils.m_94005_((FormattedText)display, (int)(this.f_93388_ - 10), (Font)Minecraft.m_91087_().f_91062_));
            }
        }
        catch (Exception e) {
            Sentry.captureException(e);
        }
        if (this.lines.size() <= oldLines.size() || this.m_93517_() == (double)oldMaxScroll) {
            // empty if block
        }
        this.m_93410_(this.m_93518_());
    }

    private int getRowBottom(int p_getRowBottom_1_) {
        return this.m_7610_(p_getRowBottom_1_) + this.itemHeight;
    }

    protected boolean m_7987_(int i) {
        return false;
    }

    protected int m_5756_() {
        return 0;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.renderBackground) {
            this.m_7733_(poseStack);
        }
        int i = this.m_5756_();
        int j = i + 6;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        if (this.renderBackground) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93096_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_7421_((float)this.f_93393_ / 32.0f, (float)(this.f_93391_ + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_7421_((float)this.f_93392_ / 32.0f, (float)(this.f_93391_ + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_7421_((float)this.f_93392_ / 32.0f, (float)(this.f_93390_ + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_7421_((float)this.f_93393_ / 32.0f, (float)(this.f_93390_ + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            tessellator.m_85914_();
        }
        int k = this.m_5747_();
        int l = this.f_93390_ + 4 - (int)this.m_93517_();
        this.m_93451_(poseStack, k, l, mouseX, mouseY, partialTicks);
        if (this.renderBackground) {
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93096_);
            RenderSystem.m_69482_();
            RenderSystem.m_69456_((int)519);
            float f1 = 32.0f;
            int i1 = -100;
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, -100.0).m_7421_(0.0f, (float)this.f_93390_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93390_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93390_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), 0.0, -100.0).m_7421_((float)this.f_93388_ / 32.0f, 0.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, 0.0, -100.0).m_7421_(0.0f, 0.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.height, -100.0).m_7421_(0.0f, (float)this.height / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.height, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.height / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93391_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93391_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, -100.0).m_7421_(0.0f, (float)this.f_93391_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            tessellator.m_85914_();
        }
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_69472_();
        int j1 = 4;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_((double)this.f_93393_, (double)(this.f_93390_ + 4), 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_93392_, (double)(this.f_93390_ + 4), 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_93392_, (double)(this.f_93391_ - 4), 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_93393_, (double)(this.f_93391_ - 4), 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        tessellator.m_85914_();
        this.m_7415_(poseStack, mouseX, mouseY);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        if (this.gifPlayer != null && this.gifImage != null) {
            this.gifPlayer.render(poseStack, mouseX + 5, mouseY + 5, 80, 60, partialTicks);
        }
        if (this.imageRenderer != null) {
            this.imageRenderer.render(poseStack, mouseX + 5, mouseY + 5, 80, 60, partialTicks);
        }
    }

    public void tick() {
        if (this.gifPlayer != null) {
            this.gifPlayer.tick();
        }
    }

    public int m_7610_(int i) {
        return super.m_7610_(i);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.f_93388_;
    }

    public int getTop() {
        return this.top;
    }

    protected void m_93451_(PoseStack poseStack, int p_renderList_1_, int p_renderList_2_, int mouseX, int mouseY, float p_renderList_5_) {
        int i = this.lines.size();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        if (!this.lines.isEmpty()) {
            for (int j = 0; j < i; ++j) {
                int k = this.m_7610_(j);
                int l = this.getRowBottom(j);
                if (l < this.f_93390_ || k > this.f_93391_) continue;
                int i1 = p_renderList_2_ + j * this.itemHeight + this.f_93395_;
                int j1 = this.itemHeight - 4;
                int k1 = this.m_5759_();
                if (this.m_7987_(j)) {
                    int l1 = this.f_93393_ + this.f_93388_ / 2 - k1 / 2;
                    int i2 = this.f_93393_ + this.f_93388_ / 2 + k1 / 2;
                    RenderSystem.m_69472_();
                    float f = this.m_5694_() ? 1.0f : 0.5f;
                    RenderSystem.m_157429_((float)f, (float)f, (float)f, (float)1.0f);
                    bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                    bufferbuilder.m_5483_((double)l1, (double)(i1 + j1 + 2), 0.0).m_5752_();
                    bufferbuilder.m_5483_((double)i2, (double)(i1 + j1 + 2), 0.0).m_5752_();
                    bufferbuilder.m_5483_((double)i2, (double)(i1 - 2), 0.0).m_5752_();
                    bufferbuilder.m_5483_((double)l1, (double)(i1 - 2), 0.0).m_5752_();
                    tessellator.m_85914_();
                    RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                    bufferbuilder.m_5483_((double)(l1 + 1), (double)(i1 + j1 + 1), 0.0).m_5752_();
                    bufferbuilder.m_5483_((double)(i2 - 1), (double)(i1 + j1 + 1), 0.0).m_5752_();
                    bufferbuilder.m_5483_((double)(i2 - 1), (double)(i1 - 1), 0.0).m_5752_();
                    bufferbuilder.m_5483_((double)(l1 + 1), (double)(i1 - 1), 0.0).m_5752_();
                    tessellator.m_85914_();
                    RenderSystem.m_69493_();
                }
                this.renderEntry(poseStack, j, mouseX, mouseY, p_renderList_5_);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_mouseClicked_5_) {
        for (int i = 0; i < this.lines.size(); ++i) {
            boolean hovering;
            int totalWidth;
            FormattedCharSequence component = this.lines.get(i);
            int oldTotal = totalWidth = 5;
            boolean bl = hovering = mouseX > (double)oldTotal && mouseX < (double)(totalWidth += this.f_93386_.f_91062_.m_92724_(component)) && mouseY > (double)this.m_7610_(i) && mouseY < (double)(this.m_7610_(i) + this.itemHeight);
            if (!hovering) continue;
            Style style = this.f_93386_.f_91062_.m_92865_().m_92338_(component, (int)mouseX);
            this.screen.handleComponentClicked(style, mouseX, mouseY);
            return true;
        }
        return false;
    }
}

