/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.hooks.client.screen.ScreenHooks;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.MineTogetherCommon;
import net.creeperhost.minetogether.MinetogetherExpectPlatform;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.io.sentry.Sentry;
import net.creeperhost.minetogether.lib.MineTogether;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.module.chat.ClientChatTarget;
import net.creeperhost.minetogether.module.chat.screen.ChatListener;
import net.creeperhost.minetogether.module.chat.screen.ChatScreen;
import net.creeperhost.minetogether.module.chat.screen.FriendsListScreen;
import net.creeperhost.minetogether.screen.SettingsScreen;
import net.creeperhost.minetogether.threads.FriendUpdateThread;
import net.creeperhost.minetogether.verification.ModPackVerifier;
import net.creeperhost.minetogether.verification.SignatureVerifier;
import net.creeperhost.polylib.client.screen.widget.buttons.ButtonMultiple;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.io.FileUtils;

public class ChatModule {
    public static ClientChatTarget clientChatTarget = ClientChatTarget.DEFAULT;
    public static ClientChatTarget lastSelected = ClientChatTarget.DEFAULT;
    public static boolean hasNewMessage = true;
    public static ArrayList<String> mutedUsers = new ArrayList();
    public static Path mutedUsersPath = Platform.getGameFolder().resolve("local/minetogether/mutedusers.json");
    private static MineTogetherChat mineTogetherChat;

    public static void init() {
        MineTogether.init("MineTogether-mod/5.2.0 Launcher/" + Minecraft.m_91087_().m_91388_() + " Minecraft/" + Platform.getMinecraftVersion() + " Modloader/" + MinetogetherExpectPlatform.getModLoader());
        String ourNick = "MT" + ChatCallbacks.getPlayerHash(MineTogetherClient.getUUID()).substring(0, 28);
        FriendUpdateThread.init();
        ChatModule.buildChat(ourNick);
        ChatModule.loadMutedList();
    }

    public static void buildChat(String ourNick) {
        MineTogetherCommon.logger.info("Building MineTogether chat");
        boolean online = MineTogetherClient.isOnlineUUID;
        String realName = new ModPackVerifier().verify();
        String signature = new SignatureVerifier().verify();
        mineTogetherChat = new MineTogetherChat(ourNick, MineTogetherClient.getPlayerHash(), online, realName, signature, "", ChatListener.INSTANCE);
        Sentry.setTag("isOnline", String.valueOf(online));
        Sentry.setTag("hash", MineTogetherClient.getPlayerHash());
        Sentry.setTag("signature", signature);
        if (online) {
            mineTogetherChat.startChat();
        }
    }

    public static void onScreenOpen(Screen screen, ScreenAccess screenAccess) {
        Button friendsButton = new Button(screen.f_96543_ - 105, 5, 100, 20, (Component)new TranslatableComponent("minetogether.multiplayer.friends"), p -> Minecraft.m_91087_().m_91152_((Screen)new FriendsListScreen(screen)));
        ButtonMultiple chatButton = new ButtonMultiple(screen.f_96543_ - 125, 5, Config.getInstance().isChatEnabled() ? 1 : 3, Constants.WIDGETS_LOCATION, p -> Minecraft.m_91087_().m_91152_((Screen)(Config.getInstance().isChatEnabled() ? new ChatScreen(screen) : new SettingsScreen(screen))));
        if (screen instanceof TitleScreen && Config.getInstance().isEnableMainMenuFriends() && Config.instance.isMainMenuEnabled()) {
            ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)friendsButton);
            ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)chatButton);
            boolean bl = friendsButton.f_93623_ = !Config.getInstance().getFirstConnect();
        }
        if (screen instanceof PauseScreen) {
            ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)friendsButton);
            ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)chatButton);
            friendsButton.f_93623_ = !Config.getInstance().getFirstConnect();
        }
    }

    public static void sendMessage(String channel, Component component) {
        if (clientChatTarget != ClientChatTarget.DEFAULT) {
            MutableComponent newComp = new TextComponent("[!MineTogetherMessage]" + component.getString()).m_130948_(component.m_7383_());
            ClientChatTarget current = clientChatTarget;
            if (channel.equals(ChatHandler.CHANNEL)) {
                clientChatTarget = ClientChatTarget.MINETOGETHER;
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)newComp);
            }
            if (ChatHandler.hasParty && channel.equals(ChatHandler.currentParty)) {
                clientChatTarget = ClientChatTarget.PARTY;
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)newComp);
            }
            clientChatTarget = current;
        }
    }

    public static void muteUser(String user) {
        if (mutedUsers.contains(user)) {
            return;
        }
        mutedUsers.add(user);
        CompletableFuture.runAsync(() -> {
            Profile profile = KnownUsers.findByHash(user);
            if (profile == null) {
                profile = KnownUsers.add(user);
            }
            try {
                profile.loadProfile();
            }
            catch (IOException e) {
                Sentry.captureException(e);
            }
            profile.setMuted(true);
            KnownUsers.update(profile);
        }, MineTogetherChat.profileExecutor);
        Gson gson = new Gson();
        try {
            if (!mutedUsersPath.getParent().toFile().exists()) {
                mutedUsersPath.getParent().toFile().mkdirs();
            }
            FileUtils.writeStringToFile((File)mutedUsersPath.toFile(), (String)gson.toJson(mutedUsers), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            MineTogetherCommon.sentryException(e);
        }
    }

    public static void unmuteUser(String longhash) {
        try {
            mutedUsers.remove(longhash);
            CompletableFuture.runAsync(() -> {
                Profile profile = KnownUsers.findByHash(longhash);
                if (profile == null) {
                    profile = KnownUsers.add(longhash);
                }
                try {
                    profile.loadProfile();
                }
                catch (IOException e) {
                    Sentry.captureException(e);
                }
                profile.setMuted(false);
                KnownUsers.update(profile);
            }, MineTogetherChat.profileExecutor);
        }
        catch (Exception e) {
            Sentry.captureException(e);
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        try {
            if (!mutedUsersPath.getParent().toFile().exists()) {
                mutedUsersPath.getParent().toFile().mkdirs();
            }
            FileUtils.writeStringToFile((File)mutedUsersPath.toFile(), (String)gson.toJson(mutedUsers), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            MineTogetherCommon.sentryException(e);
        }
    }

    public static void loadMutedList() {
        if (!mutedUsersPath.toFile().exists()) {
            return;
        }
        Gson gson = new Gson();
        try {
            FileReader fileReader = new FileReader(mutedUsersPath.toFile());
            mutedUsers = (ArrayList)gson.fromJson((Reader)fileReader, ArrayList.class);
            for (String s : mutedUsers) {
                CompletableFuture.runAsync(() -> {
                    Profile profile = KnownUsers.findByHash(s);
                    if (profile == null) {
                        profile = KnownUsers.add(s);
                    }
                    try {
                        profile.loadProfile();
                    }
                    catch (IOException e) {
                        Sentry.captureException(e);
                    }
                    profile.setMuted(true);
                    KnownUsers.update(profile);
                }, MineTogetherChat.profileExecutor);
            }
        }
        catch (Exception e) {
            MineTogetherCommon.sentryException(e);
        }
    }

    public static MineTogetherChat getMineTogetherChat() {
        return mineTogetherChat;
    }
}

