/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogetherCommon;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Message;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.util.ComponentUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;

public class ChatFormatter {
    private static final Pattern nameRegex = Pattern.compile("^(\\w+?):");
    private static final Pattern patternA = Pattern.compile("((?:user)([a-zA-Z0-9]+))", 10);
    private static final Pattern patternB = Pattern.compile("((?:@)([a-zA-Z0-9]+))", 10);
    private static final Pattern patternC = Pattern.compile("((?:@user)([a-zA-Z0-9]+))", 10);
    private static final Pattern patternD = Pattern.compile("((?:@user)#([a-zA-Z0-9]+))", 10);
    private static final Pattern patternE = Pattern.compile("((?:user)#([a-zA-Z0-9]+))", 10);
    private static final Pattern patternF = Pattern.compile("([a-zA-Z0-9]+)#([a-zA-Z0-9]+)", 10);
    private static final Pattern patternG = Pattern.compile("(@[a-zA-Z0-9]+)#([a-zA-Z0-9]+)", 10);

    public static Component formatLine(Message message) {
        try {
            String inputNick;
            message.messageStr = message.messageStr.replace("[!MineTogetherMessage]", "");
            String outputNick = inputNick = message.sender;
            if (inputNick.contains(":")) {
                String[] split = inputNick.split(":");
                switch (split[0]) {
                    case "FR": {
                        if (split.length < 2) {
                            return null;
                        }
                        String nick = split[1];
                        Profile profile = KnownUsers.findByNick(nick);
                        if (profile == null) {
                            profile = KnownUsers.add(nick);
                        }
                        String nickDisplay = profile.isFriend() ? profile.getFriendName() : profile.getUserDisplay();
                        String cmdStr = message.messageStr;
                        String[] cmdSplit = cmdStr.split(" ");
                        if (cmdSplit.length < 2) {
                            return null;
                        }
                        String friendCode = cmdSplit[0];
                        StringBuilder nameBuilder = new StringBuilder();
                        for (int i = 1; i < cmdSplit.length; ++i) {
                            nameBuilder.append(cmdSplit[i]);
                        }
                        String friendName = nameBuilder.toString();
                        TranslatableComponent userComp = new TranslatableComponent("(" + nickDisplay + ") would like to add you as a friend. Click to ");
                        TranslatableComponent accept = new TranslatableComponent("<Accept>");
                        accept = accept.m_6881_().m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "AC:" + nick + ":" + friendCode + ":" + friendName)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN)));
                        userComp.m_7360_().add(accept);
                        return userComp;
                    }
                    case "FA": {
                        if (split.length < 2) {
                            return null;
                        }
                        String nick = split[1];
                        Profile profile = KnownUsers.findByNick(nick);
                        if (profile == null) {
                            profile = KnownUsers.add(nick);
                        }
                        String nickDisplay = profile.isFriend() ? profile.getFriendName() : profile.getUserDisplay();
                        TranslatableComponent userComp = new TranslatableComponent(" (" + nickDisplay + ") accepted your friend request.");
                        return userComp;
                    }
                }
            }
            AtomicBoolean premium = new AtomicBoolean(false);
            Profile profile = null;
            if (inputNick.startsWith("MT") && inputNick.length() >= 16) {
                profile = KnownUsers.findByNick(inputNick);
                if (profile == null) {
                    profile = KnownUsers.add(inputNick);
                }
                if (profile != null) {
                    premium.set(profile.isPremium());
                    outputNick = profile.getUserDisplay();
                }
                if (inputNick.equals(MineTogetherChat.profile.get().getShortHash()) || inputNick.equals(MineTogetherChat.profile.get().getMediumHash())) {
                    outputNick = MineTogetherChat.profile.get().getUserDisplay();
                } else if (profile.isMuted()) {
                    return null;
                }
            } else if (!inputNick.equals("System")) {
                return null;
            }
            TranslatableComponent base = new TranslatableComponent("");
            ChatFormatting nickColour = ChatFormatting.WHITE;
            ChatFormatting arrowColour = ChatFormatting.WHITE;
            ChatFormatting messageColour = ChatFormatting.WHITE;
            if (profile != null && profile.isFriend()) {
                nickColour = ChatFormatting.YELLOW;
                outputNick = profile.friendName;
                if (!ChatHandler.autocompleteNames.contains(outputNick)) {
                    ChatHandler.autocompleteNames.add(outputNick);
                }
            }
            TranslatableComponent userComp = new TranslatableComponent(outputNick);
            String messageStr = message.messageStr;
            CharSequence[] split = messageStr.split(" ");
            boolean highlight = false;
            for (int i = 0; i < split.length; ++i) {
                String splitStr = split[i];
                String justNick = splitStr.replaceAll("[^A-Za-z0-9#]", "");
                if (!justNick.startsWith("MT") || justNick.length() < 16) continue;
                if (MineTogetherChat.profile.get() != null && (justNick.equals(MineTogetherChat.profile.get().getShortHash()) || justNick.equals(MineTogetherChat.profile.get().getMediumHash())) || justNick.equals(MineTogetherChat.INSTANCE.ourNick)) {
                    splitStr = splitStr.replaceAll(justNick, ChatFormatting.RED + Minecraft.m_91087_().f_91074_.m_7755_().getString() + messageColour);
                    split[i] = splitStr;
                    highlight = true;
                    continue;
                }
                if (justNick.length() < 16) continue;
                Object userName = "User#" + justNick.substring(2, 5);
                Profile mentionProfile = KnownUsers.findByNick(justNick);
                if (mentionProfile != null) {
                    userName = mentionProfile.getUserDisplay();
                }
                if (userName == null) continue;
                splitStr = splitStr.replaceAll(justNick, (String)userName);
                split[i] = splitStr;
            }
            messageStr = String.join((CharSequence)" ", split);
            Component messageComp = ChatFormatter.newChatWithLinksOurs(messageStr);
            if (profile != null && profile.isBanned() || ChatHandler.backupBan.get().contains(inputNick)) {
                messageComp = new TranslatableComponent(ChatFormatting.OBFUSCATED + "<Message Deleted>").m_6881_().m_130938_(style -> style.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_GRAY)));
                messageColour = ChatFormatting.DARK_GRAY;
            }
            messageComp.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE));
            if (profile != null && !profile.getPackID().isEmpty() && ChatFormatter.profilePackMatcher(profile)) {
                nickColour = ChatFormatting.DARK_PURPLE;
                if (profile.isFriend()) {
                    nickColour = ChatFormatting.GOLD;
                }
            }
            if (inputNick.equals(MineTogetherChat.INSTANCE.ourNick)) {
                nickColour = ChatFormatting.GRAY;
                arrowColour = premium.get() ? ChatFormatting.GREEN : ChatFormatting.GRAY;
                messageColour = ChatFormatting.GRAY;
                outputNick = MineTogetherChat.profile.get().getUserDisplay();
                userComp = new TranslatableComponent(outputNick);
            }
            if (premium.get()) {
                arrowColour = ChatFormatting.GREEN;
            } else if (outputNick.equals("System")) {
                Matcher matcher = nameRegex.matcher(messageStr);
                if (matcher.find()) {
                    outputNick = matcher.group();
                    messageStr = messageStr.substring(outputNick.length() + 1);
                    outputNick = outputNick.substring(0, outputNick.length() - 1);
                    messageComp = ChatFormatter.newChatWithLinksOurs(messageStr);
                    userComp = new TranslatableComponent(outputNick);
                }
                nickColour = ChatFormatting.AQUA;
            }
            userComp = new TranslatableComponent(arrowColour + "<" + nickColour + userComp.getString() + arrowColour + "> ");
            if (!inputNick.equals(MineTogetherChat.INSTANCE.ourNick) && inputNick.startsWith("MT")) {
                String finalOutputNick = outputNick;
                userComp = userComp.m_6881_().m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, finalOutputNick)));
            }
            ChatFormatting finalMessageColour = messageColour;
            messageComp = messageComp.m_6881_().m_130938_(style -> style.m_131148_(TextColor.m_131270_((ChatFormatting)finalMessageColour)));
            if (Config.getInstance().getFirstConnect()) {
                messageComp = new TranslatableComponent(messageComp.getString());
                messageComp = messageComp.m_6881_().m_130938_(style -> style.m_131150_(Constants.GALACTIC_ALT_FONT));
            }
            base.m_7360_().add(userComp);
            base.m_7360_().add(messageComp);
            return base;
        }
        catch (Throwable e) {
            MineTogetherCommon.logger.error("Failed to format line: Sender " + message.sender + " Message" + message.messageStr);
            e.printStackTrace();
            return new TranslatableComponent("Error formatting line, Please report this to the issue tracker");
        }
    }

    public static String rot13(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean profilePackMatcher(Profile profile) {
        if (profile == null) {
            return false;
        }
        if (profile.getPackID().isEmpty()) {
            return false;
        }
        if (MineTogetherChat.profile.get().getPackID().isEmpty()) {
            return false;
        }
        String profilePack = ChatFormatter.getCleanedPackID(profile);
        String ourID = ChatFormatter.getCleanedPackID(MineTogetherChat.profile.get());
        if (profilePack.isEmpty()) {
            return false;
        }
        if (ourID.isEmpty()) {
            return false;
        }
        return profilePack.equals(ourID);
    }

    public static String getCleanedPackID(Profile profile) {
        if (profile == null) {
            return "";
        }
        String json = profile.getPackID();
        JsonElement jElement = new JsonParser().parse(json);
        JsonObject jObject = jElement.getAsJsonObject();
        String id = jObject.get("p").getAsString();
        if (id == null) {
            return "";
        }
        return id;
    }

    public static String getStringForSending(String text) {
        CharSequence[] split = text.split(" ");
        boolean replaced = false;
        for (int i = 0; i < split.length; ++i) {
            Profile profile;
            String word = split[i].toLowerCase();
            String subst = "User#$2";
            String substr2 = "$1#$2";
            Matcher matcher = patternA.matcher(word);
            Matcher matcherb = patternB.matcher(word);
            Matcher matcherc = patternC.matcher(word);
            Matcher matcherd = patternD.matcher(word);
            Matcher matchere = patternE.matcher(word);
            Matcher matcherf = patternF.matcher(word);
            Matcher matcherg = patternG.matcher(word);
            String justNick = word;
            String result = word;
            String result2 = "";
            if (matcher.matches()) {
                result = matcher.replaceAll("User#$2");
            } else if (matcherb.matches()) {
                result = matcherb.replaceAll("User#$2");
            } else if (matcherc.matches()) {
                result = matcherc.replaceAll("User#$2");
            } else if (matcherd.matches()) {
                result = matcherd.replaceAll("User#$2");
            } else if (matchere.matches()) {
                result = matchere.replaceAll("User#$2");
            } else if (matcherg.matches()) {
                result2 = matcherg.replaceAll("$1#$2");
            } else if (matcherf.matches()) {
                result2 = matcherf.replaceAll("$1#$2");
            }
            if (!result.startsWith("User") && result2.length() <= 0 || (profile = KnownUsers.findByDisplay(justNick = result2.length() > 0 ? result2.replaceAll("[^A-Za-z0-9#]", "") : result.replaceAll("[^A-Za-z0-9#]", ""))) == null) continue;
            String tempWord = profile.getShortHash();
            if (tempWord != null) {
                split[i] = result.replaceAll(justNick, tempWord);
                replaced = true;
                continue;
            }
            if (!justNick.toLowerCase().equals(Minecraft.m_91087_().m_91094_().m_92546_())) continue;
            split[i] = result.replaceAll(justNick, MineTogetherChat.INSTANCE.ourNick);
            replaced = true;
        }
        if (replaced) {
            text = String.join((CharSequence)" ", split);
        }
        return text;
    }

    public static Component newChatWithLinksOurs(String string) {
        Component component = ComponentUtils.newChatWithLinks(string, true);
        if (component.m_7383_().m_131182_() != null) {
            Component oldcomponent = component;
            List siblings = oldcomponent.m_7360_();
            component = new TranslatableComponent("");
            component.m_7360_().add(oldcomponent);
            for (Component sibling : siblings) {
                component.m_7360_().add(sibling);
            }
            siblings.clear();
        }
        return component;
    }
}

