/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.mixin;

import com.mojang.authlib.GameProfile;
import java.net.SocketAddress;
import java.util.List;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.module.chat.ChatFormatter;
import net.creeperhost.minetogether.module.connect.ConnectHelper;
import net.creeperhost.minetogether.module.connect.OurServerListEntryLanDetected;
import net.creeperhost.minetogetherconnect.ConnectMain;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public abstract class MixinPlayerList {
    @Shadow
    @Final
    private MinecraftServer f_11195_;
    @Shadow
    @Final
    private List<ServerPlayer> f_11196_;
    private static final Component NOT_FRIEND_COMPONENT = new TranslatableComponent("minetogether.connect.join.notfriend");

    @Shadow
    public abstract int m_11310_();

    @Inject(at={@At(value="RETURN")}, method={"getMaxPlayers()I"}, cancellable=true)
    private void getMaxPlayers(CallbackInfoReturnable<Integer> cir) {
        if (ConnectHelper.isShared(this.f_11195_)) {
            cir.setReturnValue((Object)ConnectMain.maxPlayerCount);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;"}, cancellable=true)
    private void canPlayerJoinHook(SocketAddress socket, GameProfile profile, CallbackInfoReturnable<Component> cir) {
        if (ConnectHelper.isShared(this.f_11195_)) {
            boolean isFriend;
            String playerHash = ChatCallbacks.getPlayerHash(profile.getId());
            Profile byHash = KnownUsers.findByHash(playerHash);
            boolean bl = isFriend = byHash == null || !byHash.isFriend();
            if (isFriend) {
                cir.setReturnValue((Object)NOT_FRIEND_COMPONENT);
            } else if (this.f_11196_.size() >= this.m_11310_()) {
                cir.setReturnValue((Object)OurServerListEntryLanDetected.FULL_MESSAGE_COMPONENT);
                Component component = ChatFormatter.newChatWithLinksOurs(I18n.m_118938_((String)"minetogether.connect.join.tried.name", (Object[])new Object[]{byHash.getUserDisplay(), ConnectMain.maxPlayerCount}));
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(component);
            }
        }
    }
}

