/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.io.sentry.Sentry;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatConnectionStatus;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.lib.chat.irc.IrcHandler;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.module.chat.ClientChatTarget;
import net.creeperhost.minetogether.module.chat.screen.ChatScreen;
import net.creeperhost.minetogether.module.chat.screen.FriendRequestScreen;
import net.creeperhost.minetogether.module.chat.screen.widgets.GuiButtonPair;
import net.creeperhost.minetogether.util.ComponentUtils;
import net.creeperhost.polylib.client.gif.AnimatedGif;
import net.creeperhost.polylib.client.screen.widget.buttons.ButtonNoBlend;
import net.creeperhost.polylib.client.screen.widget.buttons.DropdownButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
public abstract class MixinChatScreen
extends Screen {
    @Shadow
    protected EditBox f_95573_;
    @Shadow
    private CommandSuggestions f_95577_;
    @Shadow
    private String f_95576_;
    private GuiButtonPair switchButton;
    private DropdownButton<ChatScreen.Menu> dropdownButton;
    private String currentDropdown;
    private int mouseX;
    private int mouseY;
    private Button newUserButton;
    private Button disableButton;
    private AnimatedGif gifImage;
    private AnimatedGif.GifPlayer gifPlayer;

    @Shadow
    public abstract void m_6305_(PoseStack var1, int var2, int var3, float var4);

    protected MixinChatScreen(Component component) {
        super(component);
    }

    @Inject(at={@At(value="TAIL")}, method={"init()V"})
    public void init(CallbackInfo ci) {
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        if (ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER) {
            this.f_95577_.m_93922_(false);
        }
        if (this.f_95576_.equalsIgnoreCase("/")) {
            if (ChatModule.clientChatTarget != ClientChatTarget.DEFAULT) {
                ChatModule.lastSelected = ChatModule.clientChatTarget;
            }
            ChatModule.clientChatTarget = ClientChatTarget.DEFAULT;
        } else if (ChatModule.lastSelected != ClientChatTarget.DEFAULT) {
            ChatModule.clientChatTarget = ChatModule.lastSelected;
        }
        int x = Mth.m_14167_((float)Minecraft.m_91087_().f_91065_.m_93076_().m_93813_()) + 16 + 2;
        if (ChatHandler.hasParty) {
            this.switchButton = new GuiButtonPair(x, this.f_96544_ - 215, 234, 16, ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER ? 1 : 0, false, false, true, p -> {
                if (this.switchButton.activeButton == 2) {
                    ChatModule.clientChatTarget = ClientChatTarget.PARTY;
                    return;
                }
                ChatModule.clientChatTarget = this.switchButton.activeButton == 1 ? ClientChatTarget.MINETOGETHER : ClientChatTarget.DEFAULT;
            }, MixinChatScreen.isSinglePlayer() ? I18n.m_118938_((String)"minetogether.ingame.chat.local", (Object[])new Object[0]) : I18n.m_118938_((String)"minetogether.ingame.chat.server", (Object[])new Object[0]), I18n.m_118938_((String)"minetogether.ingame.chat.global", (Object[])new Object[0]), I18n.m_118938_((String)"minetogether.ingame.chat.party", (Object[])new Object[0]));
            this.m_142416_((GuiEventListener)this.switchButton);
        } else {
            this.switchButton = new GuiButtonPair(x, this.f_96544_ - 215, 234, 16, ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER ? 1 : 0, false, false, true, p -> {
                ClientChatTarget clientChatTarget = ChatModule.clientChatTarget = this.switchButton.activeButton == 1 ? ClientChatTarget.MINETOGETHER : ClientChatTarget.DEFAULT;
                if (this.switchButton.activeButton == 1 && ChatHandler.connectionStatus == ChatConnectionStatus.VERIFIED) {
                    IrcHandler.sendCTCPMessage("Freddy", "ACTIVE", "");
                }
            }, MixinChatScreen.isSinglePlayer() ? I18n.m_118938_((String)"minetogether.ingame.chat.local", (Object[])new Object[0]) : I18n.m_118938_((String)"minetogether.ingame.chat.server", (Object[])new Object[0]), I18n.m_118938_((String)"minetogether.ingame.chat.global", (Object[])new Object[0]));
            this.m_142416_((GuiEventListener)this.switchButton);
        }
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(I18n.m_118938_((String)"minetogether.chat.button.mute", (Object[])new Object[0]));
        strings.add(I18n.m_118938_((String)"minetogether.chat.button.addfriend", (Object[])new Object[0]));
        strings.add(I18n.m_118938_((String)"minetogether.chat.button.mention", (Object[])new Object[0]));
        this.dropdownButton = new DropdownButton(-1000, -1000, 100, 20, (Component)new TranslatableComponent("Menu"), (DropdownButton.IDropdownOption)new ChatScreen.Menu(strings), true, p -> {
            if (((ChatScreen.Menu)this.dropdownButton.getSelected()).option.equals(I18n.m_118938_((String)"minetogether.chat.button.mute", (Object[])new Object[0]))) {
                ChatModule.muteUser(KnownUsers.findByDisplay(this.currentDropdown).getLongHash());
                KnownUsers.findByDisplay(this.currentDropdown).setMuted(true);
                ChatHandler.addStatusMessage("Locally blocked " + this.currentDropdown);
            } else if (((ChatScreen.Menu)this.dropdownButton.getSelected()).option.equals(I18n.m_118938_((String)"minetogether.chat.button.addfriend", (Object[])new Object[0]))) {
                Profile profile = KnownUsers.findByDisplay(this.currentDropdown);
                if (profile != null) {
                    try {
                        this.f_96541_.m_91152_((Screen)new FriendRequestScreen(this, this.f_96541_.m_91094_().m_92546_(), profile, ChatCallbacks.getFriendCode(MineTogetherClient.getPlayerHash()), "", false, false));
                    }
                    catch (IOException e) {
                        Sentry.captureException(e);
                    }
                }
            } else if (((ChatScreen.Menu)this.dropdownButton.getSelected()).option.equals(I18n.m_118938_((String)"minetogether.chat.button.mention", (Object[])new Object[0]))) {
                this.f_95573_.m_94178_(true);
                this.f_95573_.m_94144_(this.f_95573_.m_94155_() + " " + this.currentDropdown + " ");
            }
        }, false);
        this.m_142416_((GuiEventListener)this.dropdownButton);
        this.dropdownButton.flipped = true;
        if (Config.getInstance().getFirstConnect() && ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER) {
            ChatCallbacks.updateOnlineCount();
            this.newUserButton = new ButtonNoBlend(6, this.f_96544_ - (this.f_96541_.f_91065_.m_93076_().m_93814_() + 80) / 2 + 45, this.f_96541_.f_91065_.m_93076_().m_93813_() - 2, 20, (Component)new TranslatableComponent("Join " + ChatCallbacks.onlineCount + " online users now!"), p -> {
                IrcHandler.sendCTCPMessage("Freddy", "ACTIVE", "");
                Config.getInstance().setFirstConnect(false);
                this.newUserButton.f_93624_ = false;
                this.disableButton.f_93624_ = false;
                this.f_96541_.m_91152_(null);
            });
            this.m_142416_((GuiEventListener)this.newUserButton);
            this.disableButton = new ButtonNoBlend(6, this.f_96544_ - (this.f_96541_.f_91065_.m_93076_().m_93814_() + 80) / 2 + 70, this.f_96541_.f_91065_.m_93076_().m_93813_() - 2, 20, (Component)new TranslatableComponent("Don't ask me again"), p -> {
                Config.getInstance().setChatEnabled(false);
                this.disableButton.f_93624_ = false;
                this.newUserButton.f_93624_ = false;
                IrcHandler.stop(true);
                this.m_169413_();
            });
            this.m_142416_((GuiEventListener)this.disableButton);
        }
    }

    private static boolean isSinglePlayer() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.m_91092_() == null) {
            return false;
        }
        if (minecraft.m_91092_().m_6992_()) {
            return false;
        }
        return minecraft.m_91090_();
    }

    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    public void render(PoseStack poseStack, int i, int j, float partialTicks, CallbackInfo ci) {
        Style style;
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        if (this.f_96541_ == null) {
            return;
        }
        this.mouseX = i;
        this.mouseY = j;
        this.m_7522_((GuiEventListener)this.f_95573_);
        this.f_95573_.m_94178_(true);
        MixinChatScreen.m_93172_((PoseStack)poseStack, (int)2, (int)(this.f_96544_ - 14), (int)(this.f_96543_ - 2), (int)(this.f_96544_ - 2), (int)this.f_96541_.f_91066_.m_92143_(Integer.MIN_VALUE));
        this.f_95573_.m_6305_(poseStack, i, j, partialTicks);
        if (ChatModule.clientChatTarget == ClientChatTarget.DEFAULT) {
            this.f_95577_.m_93900_(poseStack, i, j);
        }
        if ((style = this.f_96541_.f_91065_.m_93076_().m_93800_((double)i, (double)j)) != null && style.m_131186_() != null) {
            if (style.m_131186_().m_130820_() == ComponentUtils.RENDER_GIF) {
                Component urlComponent = (Component)style.m_131186_().m_130823_(ComponentUtils.RENDER_GIF);
                String url = urlComponent.getString();
                if (this.gifImage == null) {
                    try {
                        try {
                            this.gifImage = AnimatedGif.fromURL((URL)new URL(url));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (this.gifImage != null && this.gifPlayer == null) {
                            this.gifPlayer = this.gifImage.makeGifPlayer();
                            this.gifPlayer.setLooping(true);
                            this.gifPlayer.setAutoplay(true);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (this.gifPlayer != null) {
                    this.gifPlayer.render(poseStack, this.mouseX + 5, this.mouseY + 5, 80, 60, partialTicks);
                }
            }
            this.m_96570_(poseStack, style, i, j);
        } else {
            this.gifImage = null;
            this.gifPlayer = null;
        }
        if (Config.getInstance().getFirstConnect() && ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER) {
            ChatComponent chatComponent;
            if (this.newUserButton != null) {
                this.newUserButton.f_93624_ = true;
            }
            if (this.disableButton != null) {
                this.disableButton.f_93624_ = true;
            }
            if ((chatComponent = this.f_96541_.f_91065_.m_93076_()) != null) {
                Objects.requireNonNull(this.f_96541_.f_91062_);
                int y = this.f_96544_ - 43 - 9 * Math.max(Math.min(chatComponent.m_93797_().size(), chatComponent.m_93816_()), 20);
                MixinChatScreen.m_93172_((PoseStack)poseStack, (int)0, (int)y, (int)(chatComponent.m_93813_() + 6), (int)(chatComponent.m_93814_() + 10 + y), (int)-1728053248);
                MixinChatScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Welcome to MineTogether", (int)(chatComponent.m_93813_() / 2 + 3), (int)(this.f_96544_ - (chatComponent.m_93814_() + 80) / 2), (int)0xFFFFFF);
                MixinChatScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"MineTogether is a multiplayer enhancement mod that provides", (int)(chatComponent.m_93813_() / 2 + 3), (int)(this.f_96544_ - (chatComponent.m_93814_() + 80) / 2 + 10), (int)0xFFFFFF);
                MixinChatScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"a multitude of features like chat, friends list, server listing", (int)(chatComponent.m_93813_() / 2 + 3), (int)(this.f_96544_ - (chatComponent.m_93814_() + 80) / 2 + 20), (int)0xFFFFFF);
                MixinChatScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)("and more. Join " + ChatCallbacks.userCount + " unique users."), (int)(chatComponent.m_93813_() / 2 + 3), (int)(this.f_96544_ - (chatComponent.m_93814_() + 80) / 2 + 30), (int)0xFFFFFF);
            }
        }
        super.m_6305_(poseStack, i, j, partialTicks);
        ci.cancel();
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    public void tick(CallbackInfo ci) {
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        switch (ChatModule.clientChatTarget) {
            case DEFAULT: {
                this.switchButton.getButtons().get(0).setActive(true);
                return;
            }
            case MINETOGETHER: {
                this.switchButton.getButtons().get(1).setActive(true);
                return;
            }
            case PARTY: {
                if (this.switchButton.getButtons().size() == 3) {
                    this.switchButton.getButtons().get(2).setActive(true);
                }
                return;
            }
        }
        if (this.gifPlayer != null) {
            this.gifPlayer.tick();
        }
        if (this.f_95573_ == null) {
            return;
        }
        if (ChatModule.clientChatTarget != ClientChatTarget.DEFAULT) {
            this.f_95573_.f_93623_ = ChatHandler.connectionStatus == ChatConnectionStatus.VERIFIED;
            this.f_95573_.m_94186_(ChatHandler.connectionStatus == ChatConnectionStatus.VERIFIED);
            if (this.f_95573_.m_93696_() && ChatHandler.connectionStatus != ChatConnectionStatus.VERIFIED) {
                this.f_95573_.m_94178_(false);
            }
            switch (ChatHandler.connectionStatus) {
                case VERIFYING: {
                    this.f_95573_.m_94167_(I18n.m_118938_((String)"minetogether.chat.message.unverified", (Object[])new Object[0]));
                    break;
                }
                case BANNED: {
                    this.f_95573_.m_94167_(I18n.m_118938_((String)"minetogether.chat.message.banned", (Object[])new Object[0]));
                    break;
                }
                case DISCONNECTED: {
                    this.f_95573_.m_94167_(I18n.m_118938_((String)"minetogether.chat.message.disconnect", (Object[])new Object[0]));
                    break;
                }
                case CONNECTING: {
                    this.f_95573_.m_94167_(I18n.m_118938_((String)"minetogether.chat.message.connecting", (Object[])new Object[0]));
                    break;
                }
                case VERIFIED: {
                    this.f_95573_.m_94167_("");
                }
            }
        } else {
            this.f_95573_.f_93623_ = true;
            this.f_95573_.m_94186_(true);
            this.f_95573_.m_94167_("");
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"mouseClicked"}, cancellable=true)
    public void mouseClicked(double d, double e, int i, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        if (this.dropdownButton != null && this.dropdownButton.wasJustClosed && !this.dropdownButton.dropdownOpen) {
            this.dropdownButton.f_93621_ = -10000;
            this.dropdownButton.f_93620_ = -10000;
            this.dropdownButton.wasJustClosed = false;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onEdited"}, cancellable=true)
    private void onEdited(String string, CallbackInfo ci) {
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        if (ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER) {
            ci.cancel();
        }
    }

    public void m_96615_(String string) {
        if (!Config.getInstance().isChatEnabled()) {
            super.m_96615_(string);
            return;
        }
        if (this.f_96541_ == null) {
            return;
        }
        if (ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER) {
            if (string.startsWith("/")) {
                ChatModule.clientChatTarget = ClientChatTarget.DEFAULT;
                super.m_96615_(string);
                return;
            }
            ChatHandler.sendMessage(ChatHandler.CHANNEL, string);
            return;
        }
        if (ChatModule.clientChatTarget == ClientChatTarget.PARTY) {
            ChatHandler.sendMessage(ChatHandler.currentParty, string);
            return;
        }
        super.m_96615_(string);
    }

    public boolean m_5561_(@Nullable Style style) {
        if (!Config.getInstance().isChatEnabled()) {
            return super.m_5561_(style);
        }
        if (this.f_96541_ == null) {
            return false;
        }
        if (ChatModule.clientChatTarget == ClientChatTarget.DEFAULT) {
            return super.m_5561_(style);
        }
        if (style == null) {
            return false;
        }
        if (style.m_131182_() == null) {
            return false;
        }
        if (this.dropdownButton == null) {
            return false;
        }
        if (this.dropdownButton.dropdownOpen) {
            return false;
        }
        if (style.m_131182_().m_130622_() == ClickEvent.Action.OPEN_URL) {
            return super.m_5561_(style);
        }
        if (style.m_131182_().m_130622_() == ClickEvent.Action.SUGGEST_COMMAND) {
            this.dropdownButton.f_93620_ = this.mouseX;
            this.dropdownButton.f_93621_ = this.mouseY;
            this.dropdownButton.dropdownOpen = true;
            this.currentDropdown = style.m_131182_().m_130623_();
            return true;
        }
        return false;
    }
}

