/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.data.Message;
import net.creeperhost.minetogether.lib.util.LimitedSizeQueue;
import net.creeperhost.minetogether.mixin.ChatComponentInvoker;
import net.creeperhost.minetogether.module.chat.ChatFormatter;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.module.chat.ClientChatTarget;
import net.creeperhost.minetogether.screen.MineTogetherScreen;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatComponent.class})
public abstract class MixinChatComponent {
    @Shadow
    @Final
    private List<GuiMessage<FormattedCharSequence>> f_93761_;
    @Shadow
    @Final
    private List<GuiMessage<Component>> f_93760_;
    @Shadow
    @Final
    private Minecraft f_93758_;
    private final List<GuiMessage<FormattedCharSequence>> mtChatMessages = new ArrayList<GuiMessage<FormattedCharSequence>>();
    private final List<GuiMessage<Component>> mtAllMessages = new ArrayList<GuiMessage<Component>>();
    private final List<GuiMessage<FormattedCharSequence>> partyChatMessages = new ArrayList<GuiMessage<FormattedCharSequence>>();
    private final List<GuiMessage<Component>> partyAllMessages = new ArrayList<GuiMessage<Component>>();

    @Shadow
    public abstract int m_93813_();

    @Shadow
    protected abstract void m_93790_(Component var1, int var2, int var3, boolean var4);

    @Shadow
    protected abstract boolean m_93818_();

    @Shadow
    @Nullable
    public abstract Style m_93800_(double var1, double var3);

    @Shadow
    public abstract void m_93785_(Component var1);

    @Inject(at={@At(value="RETURN")}, method={"processPendingMessages"}, cancellable=true)
    public void getProcessPendingMessages(CallbackInfo ci) {
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        if (ChatModule.clientChatTarget != ClientChatTarget.DEFAULT && ChatModule.hasNewMessage) {
            ChatModule.hasNewMessage = false;
            this.updateList();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void render(PoseStack poseStack, int i, CallbackInfo ci) {
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        if (this.m_93818_()) {
            ChatComponent chatComponent = Minecraft.m_91087_().f_91065_.m_93076_();
            int n = chatComponent.m_93814_() - 175;
            Objects.requireNonNull(this.f_93758_.f_91062_);
            int y = n - 9 * Math.max(Math.min(chatComponent.m_93797_().size(), chatComponent.m_93816_()), 20);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)0, (int)y, (int)(chatComponent.m_93813_() + 6), (int)(chatComponent.m_93814_() + 10 + y), (int)this.f_93758_.f_91066_.m_92143_(Integer.MIN_VALUE));
            int k = Mth.m_14167_((float)((float)this.f_93758_.f_91065_.m_93076_().m_93813_() / (float)this.f_93758_.f_91066_.f_92131_));
            int z = Mth.m_14167_((float)((float)this.f_93758_.f_91065_.m_93076_().m_93814_() / (float)this.f_93758_.f_91066_.f_92131_));
            if (ChatModule.clientChatTarget != ClientChatTarget.DEFAULT) {
                MineTogetherScreen.drawLogo(poseStack, this.f_93758_.f_91062_, k + 6, z + 6, -2, this.f_93758_.f_91065_.m_93076_().m_93814_() - 340, 0.75f);
            }
        }
    }

    @Redirect(method={"render"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/components/ChatComponent;trimmedMessages:Ljava/util/List;", opcode=180))
    private List<GuiMessage<FormattedCharSequence>> trimmedMessages(ChatComponent chatComponent) {
        if (!Config.getInstance().isChatEnabled()) {
            return this.f_93761_;
        }
        switch (ChatModule.clientChatTarget) {
            case DEFAULT: {
                return this.f_93761_;
            }
            case PARTY: {
                return this.partyChatMessages;
            }
            case MINETOGETHER: {
                return this.mtChatMessages;
            }
        }
        return this.f_93761_;
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;fill(Lcom/mojang/blaze3d/vertex/PoseStack;IIIII)V"))
    private void fill(PoseStack poseStack, int i, int j, int k, int l, int m) {
        if (Config.getInstance().isChatEnabled()) {
            if (!this.m_93818_()) {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)i, (int)j, (int)k, (int)l, (int)m);
            }
        } else {
            ChatComponent.m_93172_((PoseStack)poseStack, (int)i, (int)j, (int)k, (int)l, (int)m);
        }
    }

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void addMessage(Component component, CallbackInfo ci) {
        if (component == null) {
            return;
        }
        if (!component.getString().startsWith("[!MineTogetherMessage]")) {
            ClientChatTarget current = ChatModule.clientChatTarget;
            ChatModule.clientChatTarget = ClientChatTarget.DEFAULT;
            ((ChatComponentInvoker)Minecraft.m_91087_().f_91065_.m_93076_()).invokeAddMessage(component, 0, Minecraft.m_91087_().f_91065_.m_93079_(), false);
            ChatModule.clientChatTarget = current;
            ci.cancel();
        } else {
            String message = component.getString().substring(22);
            MutableComponent newComponent = new TextComponent(message).m_130948_(component.m_7383_());
            ((ChatComponentInvoker)Minecraft.m_91087_().f_91065_.m_93076_()).invokeAddMessage((Component)newComponent, 0, Minecraft.m_91087_().f_91065_.m_93079_(), false);
            ci.cancel();
        }
    }

    @Redirect(method={"addMessage(Lnet/minecraft/network/chat/Component;IIZ)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/components/ChatComponent;trimmedMessages:Ljava/util/List;", opcode=180))
    private List<GuiMessage<FormattedCharSequence>> addMessage(ChatComponent chatComponent) {
        if (!Config.getInstance().isChatEnabled()) {
            return this.f_93761_;
        }
        switch (ChatModule.clientChatTarget) {
            case DEFAULT: {
                return this.f_93761_;
            }
            case PARTY: {
                return this.partyChatMessages;
            }
            case MINETOGETHER: {
                return this.mtChatMessages;
            }
        }
        return this.f_93761_;
    }

    @Redirect(method={"addMessage(Lnet/minecraft/network/chat/Component;IIZ)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/components/ChatComponent;allMessages:Ljava/util/List;", opcode=180))
    private List<GuiMessage<Component>> addMessageAll(ChatComponent chatComponent) {
        if (!Config.getInstance().isChatEnabled()) {
            return this.f_93760_;
        }
        switch (ChatModule.clientChatTarget) {
            case DEFAULT: {
                return this.f_93760_;
            }
            case MINETOGETHER: {
                return this.mtAllMessages;
            }
            case PARTY: {
                return this.partyAllMessages;
            }
        }
        return this.f_93760_;
    }

    @Redirect(method={"scrollChat(I)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/components/ChatComponent;trimmedMessages:Ljava/util/List;", opcode=180))
    private List<GuiMessage<FormattedCharSequence>> scrollChat(ChatComponent chatComponent) {
        if (!Config.getInstance().isChatEnabled()) {
            return this.f_93761_;
        }
        switch (ChatModule.clientChatTarget) {
            case DEFAULT: {
                return this.f_93761_;
            }
            case PARTY: {
                return this.partyChatMessages;
            }
            case MINETOGETHER: {
                return this.mtChatMessages;
            }
        }
        return this.f_93761_;
    }

    @Redirect(method={"getClickedComponentStyleAt"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/components/ChatComponent;trimmedMessages:Ljava/util/List;", opcode=180))
    private List<GuiMessage<FormattedCharSequence>> getClickedComponentStyleAt(ChatComponent chatComponent) {
        if (!Config.getInstance().isChatEnabled()) {
            return this.f_93761_;
        }
        switch (ChatModule.clientChatTarget) {
            case DEFAULT: {
                return this.f_93761_;
            }
            case PARTY: {
                return this.partyChatMessages;
            }
            case MINETOGETHER: {
                return this.mtChatMessages;
            }
        }
        return this.f_93761_;
    }

    public void updateList() {
        String channel = ChatHandler.CHANNEL;
        if (ChatModule.clientChatTarget == ClientChatTarget.PARTY) {
            channel = ChatHandler.currentParty;
        }
        try {
            LimitedSizeQueue<Message> temp = ChatHandler.messages.get(channel);
            for (Message message : temp) {
                Component component = ChatFormatter.formatLine(message);
                if (component == null) continue;
                this.m_93790_(component, 0, Minecraft.m_91087_().f_91065_.m_93079_(), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

