/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import net.creeperhost.minetogether.lib.MineTogether;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static String userAgent = "";
    private static List<String> cookies;
    private static boolean logHide;

    public static String getAPIResponse(String urlString) throws IOException, URISyntaxException {
        String line;
        URL url = new URL(urlString);
        URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        url = uri.toURL();
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        if (cookies != null) {
            for (String cookie : cookies) {
                conn.addRequestProperty("Cookie", cookie.split(";", 2)[0]);
            }
        }
        conn.setRequestProperty("User-Agent", userAgent);
        if (!MineTogether.key.isEmpty() | !MineTogether.secret.isEmpty()) {
            conn.addRequestProperty("USER_SECRET", MineTogether.secret);
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder respData = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            respData.append(line);
            respData.append("\n");
        }
        List<String> setCookies = conn.getHeaderFields().get("Set-Cookie");
        if (setCookies != null) {
            cookies = setCookies;
        }
        rd.close();
        return respData.toString();
    }

    public static String mtAPIGet(String urlString) throws IOException, URISyntaxException {
        String line;
        URL url = new URL(urlString);
        URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        url = uri.toURL();
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.addRequestProperty("APP_AUTH", MineTogether.sessionString);
        conn.setRequestProperty("User-Agent", userAgent);
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder respData = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            respData.append(line);
            respData.append("\n");
        }
        rd.close();
        return respData.toString();
    }

    public static String getWebResponse(String urlString) throws IOException, URISyntaxException {
        return WebUtils.getWebResponse(urlString, 0, false);
    }

    public static String getWebResponse(String urlString, int timeout) throws IOException, URISyntaxException {
        return WebUtils.getWebResponse(urlString, timeout, false);
    }

    public static String getWebResponse(String urlString, int timeout, boolean print) throws IOException, URISyntaxException {
        String line;
        if (timeout == 0) {
            timeout = 120000;
        }
        URL url = new URL(urlString);
        URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        url = uri.toURL();
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(true);
        conn.setReadTimeout(timeout);
        conn.setRequestMethod("GET");
        if (cookies != null) {
            for (String cookie : cookies) {
                conn.addRequestProperty("Cookie", cookie.split(";", 2)[0]);
            }
        }
        if (userAgent == null) {
            userAgent = "";
        }
        conn.setRequestProperty("User-Agent", userAgent);
        if (MineTogetherChat.INSTANCE != null) {
            if (MineTogetherChat.INSTANCE.signature != null) {
                conn.setRequestProperty("Fingerprint", MineTogetherChat.INSTANCE.signature);
            }
            if (MineTogetherChat.INSTANCE.realName != null && !MineTogetherChat.INSTANCE.realName.isEmpty()) {
                conn.setRequestProperty("Identifier", URLEncoder.encode(MineTogetherChat.INSTANCE.realName, "UTF-8"));
            }
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder respData = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            respData.append(line);
            respData.append("\n");
        }
        List<String> setCookies = conn.getHeaderFields().get("Set-Cookie");
        if (setCookies != null) {
            cookies = setCookies;
        }
        rd.close();
        return respData.toString();
    }

    public static String getWebResponseIrcServer(int timeout, boolean print) throws IOException, URISyntaxException {
        String line;
        if (timeout == 0) {
            timeout = 120000;
        }
        URL url = new URL("https://api.creeper.host/serverlist/chatserver");
        URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        url = uri.toURL();
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(true);
        conn.setReadTimeout(timeout);
        conn.setRequestMethod("GET");
        if (cookies != null) {
            for (String cookie : cookies) {
                conn.addRequestProperty("Cookie", cookie.split(";", 2)[0]);
            }
        }
        if (userAgent == null) {
            userAgent = "";
        }
        conn.setRequestProperty("User-Agent", userAgent);
        if (MineTogetherChat.INSTANCE != null) {
            if (MineTogetherChat.INSTANCE.signature != null) {
                conn.setRequestProperty("Fingerprint", MineTogetherChat.INSTANCE.signature);
            }
            if (MineTogetherChat.INSTANCE.realName != null && !MineTogetherChat.INSTANCE.realName.isEmpty()) {
                conn.setRequestProperty("Identifier", URLEncoder.encode(MineTogetherChat.INSTANCE.realName, "UTF-8"));
            }
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder respData = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            respData.append(line);
            respData.append("\n");
        }
        List<String> setCookies = conn.getHeaderFields().get("Set-Cookie");
        if (setCookies != null) {
            cookies = setCookies;
        }
        rd.close();
        return respData.toString();
    }

    public static String getWebResponseHTTP(String urlString, int timeout, boolean print) throws IOException, URISyntaxException {
        String line;
        if (timeout == 0) {
            timeout = 120000;
        }
        URL url = new URL(urlString);
        URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        url = uri.toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(true);
        conn.setReadTimeout(timeout);
        conn.setRequestMethod("GET");
        if (cookies != null) {
            for (String cookie : cookies) {
                conn.addRequestProperty("Cookie", cookie.split(";", 2)[0]);
            }
        }
        if (userAgent == null) {
            userAgent = "";
        }
        conn.setRequestProperty("User-Agent", userAgent);
        if (MineTogetherChat.INSTANCE != null) {
            if (MineTogetherChat.INSTANCE.signature != null) {
                conn.setRequestProperty("Fingerprint", MineTogetherChat.INSTANCE.signature);
            }
            if (MineTogetherChat.INSTANCE.realName != null && !MineTogetherChat.INSTANCE.realName.isEmpty()) {
                conn.setRequestProperty("Identifier", URLEncoder.encode(MineTogetherChat.INSTANCE.realName, "UTF-8"));
            }
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder respData = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            respData.append(line);
            respData.append("\n");
        }
        List<String> setCookies = conn.getHeaderFields().get("Set-Cookie");
        if (setCookies != null) {
            cookies = setCookies;
        }
        rd.close();
        return respData.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String mapToFormString(Map<String, String> map) {
        String postDataString;
        StringBuilder postDataStringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                postDataStringBuilder.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append("&");
            }
        }
        catch (Exception exception) {
        }
        finally {
            postDataString = postDataStringBuilder.toString();
        }
        return postDataString;
    }

    public static String postWebResponse(String urlString, Map<String, String> postDataMap) throws IOException {
        return WebUtils.postWebResponse(urlString, WebUtils.mapToFormString(postDataMap));
    }

    public static String methodWebResponse(String urlString, String postDataString, String method, boolean isJson, boolean silent) throws IOException {
        return WebUtils.methodWebResponse(urlString, postDataString, method, isJson ? "application/json" : "application/x-www-form-urlencoded", silent, 20000);
    }

    public static String methodWebResponse(String urlString, String postDataString, String method, boolean isJson, boolean silent, int timeout) throws IOException {
        return WebUtils.methodWebResponse(urlString, postDataString, method, isJson ? "application/json" : "application/x-www-form-urlencoded", silent, timeout);
    }

    public static String methodWebResponse(String urlString, String postDataString, String method, String contentType, boolean silent, int timeout) throws IOException {
        String line;
        byte[] postData = postDataString.getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", userAgent);
        if (MineTogetherChat.INSTANCE != null && MineTogetherChat.INSTANCE.signature != null) {
            conn.setRequestProperty("Fingerprint", MineTogetherChat.INSTANCE.signature);
        }
        if (MineTogetherChat.INSTANCE != null && MineTogetherChat.INSTANCE.realName != null && !MineTogetherChat.INSTANCE.realName.isEmpty()) {
            conn.setRequestProperty("Identifier", URLEncoder.encode(MineTogetherChat.INSTANCE.realName, "UTF-8"));
        }
        conn.setRequestMethod(method);
        if (cookies != null) {
            for (String cookie : cookies) {
                conn.addRequestProperty("Cookie", cookie.split(";", 2)[0]);
            }
        }
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("charset", "utf-8");
        conn.setRequestProperty("Content-Length", Integer.toString(postDataLength));
        conn.setConnectTimeout(timeout);
        conn.setReadTimeout(timeout);
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setInstanceFollowRedirects(true);
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.write(postData);
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder respData = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            respData.append(line);
        }
        List<String> setCookies = conn.getHeaderFields().get("Set-Cookie");
        if (setCookies != null) {
            cookies = setCookies;
        }
        rd.close();
        logHide = false;
        return respData.toString();
    }

    public static String postWebResponse(String urlString, String postDataString) throws IOException {
        return WebUtils.methodWebResponse(urlString, postDataString, "POST", false, false);
    }

    public static String postWebResponse(String urlString, String postDataString, String contentType) throws IOException {
        return WebUtils.methodWebResponse(urlString, postDataString, "POST", contentType, false, 10000);
    }

    public static String putWebResponse(String urlString, String body, boolean isJson, boolean isSilent) throws IOException {
        return WebUtils.methodWebResponse(urlString, body, "PUT", isJson, isSilent);
    }

    public static String putWebResponse(String urlString, String body, boolean isJson, boolean isSilent, int timeout) throws IOException {
        return WebUtils.methodWebResponse(urlString, body, "PUT", isJson, isSilent, timeout);
    }

    public static boolean checkExist(URL url) {
        boolean response = false;
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.connect();
            response = connection.getResponseCode() == 200 && connection.getContentLength() >= 0;
            connection.disconnect();
        }
        catch (Exception err) {
            response = false;
        }
        return response;
    }

    public static long getFileSize(URL url) {
        long response = -1L;
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.connect();
            response = connection.getContentLength();
            connection.disconnect();
        }
        catch (Exception err) {
            response = -1L;
        }
        return response;
    }

    public static void downloadFile(String downloadUrl, Path path) throws IOException {
        URL url = new URL(downloadUrl);
        ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
        FileOutputStream fileOutputStream = new FileOutputStream(path.toAbsolutePath().toString());
        FileChannel fileChannel = fileOutputStream.getChannel();
        fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
    }
}

