/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.util;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.creeperhost.minetogether.lib.MineTogether;

public class SignatureUtil {
    public static String getSignature() {
        Hasher hasher = Hashing.sha256().newHasher();
        try {
            String s = MineTogether.class.getName().replace(".", "/") + ".class";
            Class<MineTogether> clazz = MineTogether.class;
            URL resource = clazz.getClassLoader().getResource(s);
            String resourcePath = resource.toString();
            if (resourcePath.startsWith("jar:file:/")) {
                resourcePath = resourcePath.substring(10);
                int i = resourcePath.indexOf("!/");
                String jarPath = resourcePath.substring(0, i);
                ZipFile zipFile = new ZipFile(jarPath);
                zipFile.stream().filter(e -> e.getName().startsWith("net/creeperhost/minetogether/lib/") && e.getName().endsWith(".class")).forEach(e -> {
                    try (InputStream stream = zipFile.getInputStream((ZipEntry)e);){
                        ByteStreams.copy((InputStream)stream, (OutputStream)Funnels.asOutputStream((PrimitiveSink)hasher));
                        hasher.putLong(e.getLastModifiedTime().toMillis());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        HashCode hash = hasher.hash();
        return hash.toString();
    }
}

