/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static long getLastModified(Path file) {
        if (file != null) {
            try {
                return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static Path createDirectories(Path dir) {
        try {
            return Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create directories.", (Throwable)e);
            return null;
        }
    }
}

