/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.serverlists;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.serverlists.EnumFlag;
import net.creeperhost.minetogether.lib.serverlists.Invite;
import net.creeperhost.minetogether.lib.serverlists.Server;
import net.creeperhost.minetogether.lib.util.Util;
import net.creeperhost.minetogether.lib.util.WebUtils;

public class ServerListCallbacks {
    private static String userCountry;
    private static Util.CachedValue<List<Server>> serverListCache;
    private static Map<String, String> countries;

    public static Invite getInvite(UUID uuid) throws IOException {
        JsonArray invites;
        Iterator iterator;
        JsonObject obj;
        JsonParser parser;
        JsonElement element;
        String hash = ChatCallbacks.getPlayerHash(uuid);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("hash", hash);
        Gson gson = new Gson();
        String sendStr = gson.toJson(sendMap);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/friendinvites", sendStr, true, false);
        if (!resp.equals("error") && (element = (parser = new JsonParser()).parse(resp)).isJsonObject() && (obj = element.getAsJsonObject()).get("status").getAsString().equals("success") && (iterator = (invites = obj.getAsJsonArray("invites")).iterator()).hasNext()) {
            JsonElement inviteEl = (JsonElement)iterator.next();
            JsonObject invite = inviteEl.getAsJsonObject();
            JsonObject server = invite.getAsJsonObject("server");
            String host = server.get("ip").getAsString();
            int project = server.get("project").getAsInt();
            String by = invite.get("by").getAsString();
            String name = server.get("name").getAsString();
            String port = server.get("port").getAsString();
            String country = "UNK";
            String subdivision = "Unknown";
            if (server.has("location")) {
                JsonObject el = server.getAsJsonObject("location");
                country = el.get("country_code").getAsString();
                subdivision = el.get("subdivision").getAsString();
            }
            country = country.toUpperCase();
            EnumFlag flag = null;
            if (!country.isEmpty()) {
                try {
                    flag = EnumFlag.valueOf(country);
                }
                catch (IllegalArgumentException ignored) {
                    flag = EnumFlag.UNKNOWN;
                }
            }
            int uptime = server.get("uptime").getAsInt();
            int players = server.get("expected_players").getAsInt();
            String applicationURL = server.has("applicationUrl") ? server.get("applictionUrl").getAsString() : null;
            Server serverEl = new Server(name, host + ":" + port, uptime, players, flag, subdivision, applicationURL);
            return new Invite(serverEl, project, by);
        }
        return null;
    }

    public static List<Server> getServerList(Enum listType, final UUID uuid, final String base64, final String curseID) throws IOException {
        if (serverListCache == null) {
            serverListCache = new Util.CachedValue<List<Server>>(30000, new Util.CachedValue.ICacheCallback<List<Server>>(){
                private Enum lastRequest;
                private String playerHash;

                @Override
                public List<Server> get(Object ... args) throws IOException {
                    JsonObject object;
                    JsonArray array;
                    JsonElement jElement;
                    Enum listType = (Enum)args[0];
                    int enumOrdinal = listType.ordinal();
                    this.lastRequest = listType;
                    ArrayList<Server> list = new ArrayList<Server>();
                    if ("Insert curse project ID here".equals(curseID)) {
                        list.add(new Server("No project ID! Please fix the MineTogether config or ensure a version.json exists.", "127.0.0.1:25565", 0, 0, null, "Unknown", null));
                        return list;
                    }
                    HashMap<String, String> jsonPass = new HashMap<String, String>();
                    jsonPass.put("projectid", base64 == null ? curseID : base64);
                    if (enumOrdinal == 1) {
                        if (this.playerHash == null) {
                            this.playerHash = ChatCallbacks.getPlayerHash(uuid);
                        }
                        jsonPass.put("hash", this.playerHash);
                    }
                    jsonPass.put("listType", listType.name().toLowerCase());
                    Gson gson = new Gson();
                    String jsonString = gson.toJson(jsonPass);
                    String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/list", jsonString, true, false);
                    for (int retries = 0; resp.equals("error") && retries < 5; ++retries) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/list", jsonString, true, false);
                    }
                    if (!resp.equals("error") && (jElement = new JsonParser().parse(resp)).isJsonObject() && (array = (object = jElement.getAsJsonObject()).getAsJsonArray("servers")) != null) {
                        for (JsonElement serverEl : array) {
                            JsonObject server = (JsonObject)serverEl;
                            String name = ChatCallbacks.getSafe(server, "name", "unknown");
                            String host = ChatCallbacks.getSafe(server, "ip", "unknown");
                            String port = ChatCallbacks.getSafe(server, "port", "unknown");
                            String country = "UNK";
                            String subdivision = "Unknown";
                            if (server.has("location")) {
                                JsonObject el = server.getAsJsonObject("location");
                                country = ChatCallbacks.getSafe(el, "country_code", "UNK");
                                subdivision = ChatCallbacks.getSafe(el, "subdivision", "Unknown");
                            }
                            country = country.toUpperCase();
                            EnumFlag flag = null;
                            if (!country.isEmpty()) {
                                try {
                                    flag = EnumFlag.valueOf(country);
                                }
                                catch (IllegalArgumentException ignored) {
                                    flag = EnumFlag.UNKNOWN;
                                }
                            }
                            int uptime = ChatCallbacks.getSafe(server, "uptime", 0);
                            int players = ChatCallbacks.getSafe(server, "expected_players", 0);
                            String applicationURL = server.has("applicationUrl") ? server.get("applictionUrl").getAsString() : null;
                            list.add(new Server(name, host + ":" + port, uptime, players, flag, subdivision, applicationURL));
                        }
                    }
                    return list;
                }

                @Override
                public boolean needsRefresh(Object ... args) {
                    Enum listType = (Enum)args[0];
                    return listType != this.lastRequest;
                }
            });
        }
        return serverListCache.get(listType);
    }

    static {
        countries = new LinkedHashMap<String, String>(){
            {
                this.put("GB", "United Kingdom");
                this.put("US", "United States");
                this.put("NZ", "New Zealand");
                this.put("AU", "Australia");
                this.put("DK", "Denmark");
                this.put("CA", "Canada");
                this.put("SE", "Sweden");
                this.put("NO", "Norway");
                this.put("BR", "Brazil");
                this.put("ES", "Spain");
                this.put("AF", "Afghanistan");
                this.put("AX", "Aland Islands");
                this.put("AL", "Albania");
                this.put("DZ", "Algeria");
                this.put("AS", "American Samoa");
                this.put("AD", "Andorra");
                this.put("AO", "Angola");
                this.put("AI", "Anguilla");
                this.put("AQ", "Antarctica");
                this.put("AG", "Antigua and Barbuda");
                this.put("AR", "Argentina");
                this.put("AM", "Armenia");
                this.put("AW", "Aruba");
                this.put("AT", "Austria");
                this.put("AZ", "Azerbaijan");
                this.put("BS", "Bahamas");
                this.put("BH", "Bahrain");
                this.put("BD", "Bangladesh");
                this.put("BB", "Barbados");
                this.put("BY", "Belarus");
                this.put("BE", "Belgium");
                this.put("BZ", "Belize");
                this.put("BJ", "Benin");
                this.put("BM", "Bermuda");
                this.put("BT", "Bhutan");
                this.put("BO", "Bolivia, Plurinational State of");
                this.put("BQ", "Bonaire, Sint Eustatius and Saba");
                this.put("BA", "Bosnia and Herzegovina");
                this.put("BW", "Botswana");
                this.put("BV", "Bouvet Island");
                this.put("IO", "British Indian Ocean Territory");
                this.put("BN", "Brunei Darussalam");
                this.put("BG", "Bulgaria");
                this.put("BF", "Burkina Faso");
                this.put("BI", "Burundi");
                this.put("KH", "Cambodia");
                this.put("CM", "Cameroon");
                this.put("CV", "Cape Verde");
                this.put("KY", "Cayman Islands");
                this.put("CF", "Central African Republic");
                this.put("TD", "Chad");
                this.put("CL", "Chile");
                this.put("CN", "China");
                this.put("CX", "Christmas Island");
                this.put("CC", "Cocos (Keeling) Islands");
                this.put("CO", "Colombia");
                this.put("KM", "Comoros");
                this.put("CG", "Congo");
                this.put("CD", "Congo, the Democratic Republic of the");
                this.put("CK", "Cook Islands");
                this.put("CR", "Costa Rica");
                this.put("CI", "C\ufffdte d'Ivoire");
                this.put("HR", "Croatia");
                this.put("CU", "Cuba");
                this.put("CW", "Cura\ufffdao");
                this.put("CY", "Cyprus");
                this.put("CZ", "Czech Republic");
                this.put("DJ", "Djibouti");
                this.put("DM", "Dominica");
                this.put("DO", "Dominican Republic");
                this.put("EC", "Ecuador");
                this.put("EG", "Egypt");
                this.put("SV", "El Salvador");
                this.put("GQ", "Equatorial Guinea");
                this.put("ER", "Eritrea");
                this.put("EE", "Estonia");
                this.put("ET", "Ethiopia");
                this.put("FK", "Falkland Islands (Malvinas)");
                this.put("FO", "Faroe Islands");
                this.put("FJ", "Fiji");
                this.put("FI", "Finland");
                this.put("FR", "France");
                this.put("GF", "French Guiana");
                this.put("PF", "French Polynesia");
                this.put("TF", "French Southern Territories");
                this.put("GA", "Gabon");
                this.put("GM", "Gambia");
                this.put("GE", "Georgia");
                this.put("DE", "Germany");
                this.put("GH", "Ghana");
                this.put("GI", "Gibraltar");
                this.put("GR", "Greece");
                this.put("GL", "Greenland");
                this.put("GD", "Grenada");
                this.put("GP", "Guadeloupe");
                this.put("GU", "Guam");
                this.put("GT", "Guatemala");
                this.put("GG", "Guernsey");
                this.put("GN", "Guinea");
                this.put("GW", "Guinea-Bissau");
                this.put("GY", "Guyana");
                this.put("HT", "Haiti");
                this.put("HM", "Heard Island and McDonald Islands");
                this.put("VA", "Holy Sea (Vatican City State)");
                this.put("HN", "Honduras");
                this.put("HK", "Hong Kong");
                this.put("HU", "Hungary");
                this.put("IS", "Iceland");
                this.put("IN", "India");
                this.put("ID", "Indonesia");
                this.put("IR", "Iran, Islamic Republic of");
                this.put("IQ", "Iraq");
                this.put("IE", "Ireland");
                this.put("IM", "Isle of Man");
                this.put("IL", "Israel");
                this.put("IT", "Italy");
                this.put("JM", "Jamaica");
                this.put("JP", "Japan");
                this.put("JE", "Jersey");
                this.put("JO", "Jordan");
                this.put("KZ", "Kazakhstan");
                this.put("KE", "Kenya");
                this.put("KI", "Kiribati");
                this.put("KP", "Korea, Democratic People's Republic of");
                this.put("KR", "Korea, Republic of");
                this.put("KW", "Kuwait");
                this.put("KG", "Kyrgyzstan");
                this.put("LA", "Lao People's Democratic Republic");
                this.put("LV", "Latvia");
                this.put("LB", "Lebanon");
                this.put("LS", "Lesotho");
                this.put("LR", "Liberia");
                this.put("LY", "Libya");
                this.put("LI", "Liechtenstein");
                this.put("LT", "Lithuania");
                this.put("LU", "Luxembourg");
                this.put("MO", "Macao");
                this.put("MK", "Macedonia, the former Yugoslav Republic of");
                this.put("MG", "Madagascar");
                this.put("MW", "Malawi");
                this.put("MY", "Malaysia");
                this.put("MV", "Maldives");
                this.put("ML", "Mali");
                this.put("MT", "Malta");
                this.put("MH", "Marshall Islands");
                this.put("MQ", "Martinique");
                this.put("MR", "Mauritania");
                this.put("MU", "Mauritius");
                this.put("YT", "Mayotte");
                this.put("MX", "Mexico");
                this.put("FM", "Micronesia, Federated States of");
                this.put("MD", "Moldova, Republic of");
                this.put("MC", "Monaco");
                this.put("MN", "Mongolia");
                this.put("ME", "Montenegro");
                this.put("MS", "Montserrat");
                this.put("MA", "Morocco");
                this.put("MZ", "Mozambique");
                this.put("MM", "Myanmar");
                this.put("NA", "Namibia");
                this.put("NR", "Nauru");
                this.put("NP", "Nepal");
                this.put("NL", "Netherlands");
                this.put("NC", "New Caledonia");
                this.put("NI", "Nicaragua");
                this.put("NE", "Niger");
                this.put("NG", "Nigeria");
                this.put("NU", "Niue");
                this.put("NF", "Norfolk Island");
                this.put("MP", "Northern Mariana Islands");
                this.put("OM", "Oman");
                this.put("PK", "Pakistan");
                this.put("PW", "Palau");
                this.put("PS", "Palestinian Territory, Occupied");
                this.put("PA", "Panama");
                this.put("PG", "Papua New Guinea");
                this.put("PY", "Paraguay");
                this.put("PE", "Peru");
                this.put("PH", "Philippines");
                this.put("PN", "Pitcairn");
                this.put("PL", "Poland");
                this.put("PT", "Portugal");
                this.put("PR", "Puerto Rico");
                this.put("QA", "Qatar");
                this.put("RE", "R\ufffdunion");
                this.put("RO", "Romania");
                this.put("RU", "Russian Federation");
                this.put("RW", "Rwanda");
                this.put("BL", "Saint Barth\ufffdlemy");
                this.put("SH", "Saint Helena, Ascension and Tristan da Cunha");
                this.put("KN", "Saint Kitts and Nevis");
                this.put("LC", "Saint Lucia");
                this.put("MF", "Saint Martin (French part)");
                this.put("PM", "Saint Pierre and Miquelon");
                this.put("VC", "Saint Vincent and the Grenadines");
                this.put("WS", "Samoa");
                this.put("SM", "San Marino");
                this.put("ST", "Sao Tome and Principe");
                this.put("SA", "Saudi Arabia");
                this.put("SN", "Senegal");
                this.put("RS", "Serbia");
                this.put("SC", "Seychelles");
                this.put("SL", "Sierra Leone");
                this.put("SG", "Singapore");
                this.put("SX", "Sint Maarten (Dutch part)");
                this.put("SK", "Slovakia");
                this.put("SI", "Slovenia");
                this.put("SB", "Solomon Islands");
                this.put("SO", "Somalia");
                this.put("ZA", "South Africa");
                this.put("GS", "South Georgia and the South Sandwich Islands");
                this.put("SS", "South Sudan");
                this.put("LK", "Sri Lanka");
                this.put("SD", "Sudan");
                this.put("SR", "Suriname");
                this.put("SJ", "Svalbard and Jan Mayen");
                this.put("SZ", "Swaziland");
                this.put("CH", "Switzerland");
                this.put("SY", "Syrian Arab Republic");
                this.put("TW", "Taiwan, Province of China");
                this.put("TJ", "Tajikistan");
                this.put("TZ", "Tanzania, United Republic of");
                this.put("TH", "Thailand");
                this.put("TL", "Timor-Leste");
                this.put("TG", "Togo");
                this.put("TK", "Tokelau");
                this.put("TO", "Tonga");
                this.put("TT", "Trinidad and Tobago");
                this.put("TN", "Tunisia");
                this.put("TR", "Turkey");
                this.put("TM", "Turkmenistan");
                this.put("TC", "Turks and Caicos Islands");
                this.put("TV", "Tuvalu");
                this.put("UG", "Uganda");
                this.put("UA", "Ukraine");
                this.put("AE", "United Arab Emirates");
                this.put("UM", "United States Minor Outlying Islands");
                this.put("UY", "Uruguay");
                this.put("UZ", "Uzbekistan");
                this.put("VU", "Vanuatu");
                this.put("VE", "Venezuela, Bolivarian Republic of");
                this.put("VN", "Viet Nam");
                this.put("VG", "Virgin Islands, British");
                this.put("VI", "Virgin Islands, U.S.");
                this.put("WF", "Wallis and Futuna");
                this.put("EH", "Western Sahara");
                this.put("YE", "Yemen");
                this.put("ZM", "Zambia");
                this.put("ZW", "Zimbabwe");
                this.put("UNKNOWN", "Unknown");
            }
        };
    }
}

