/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Message;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.lib.util.LimitedSizeQueue;

public class KnownUsers {
    private static AtomicReference<List<Profile>> profiles = new AtomicReference();
    private static long lastFriendsUpdate;

    public static void clean() {
        ArrayList<String> remove = new ArrayList<String>();
        ArrayList profilesCopy = new ArrayList(profiles.get());
        for (Profile profile : profilesCopy) {
            if (profile.getUserDisplay().isEmpty() || profile.isFriend() || profile.isMuted() || profile.isBanned()) continue;
            LimitedSizeQueue<Message> tempMessages = ChatHandler.messages.get(ChatHandler.CHANNEL);
            boolean skip = false;
            for (Message message : tempMessages) {
                if (message.sender.equals("System") || !message.sender.equalsIgnoreCase(profile.getUserDisplay()) && !message.sender.equalsIgnoreCase(profile.getMediumHash()) && !message.sender.equalsIgnoreCase(profile.getShortHash())) continue;
                skip = true;
                break;
            }
            if (skip || profile.getLongHash().length() <= 0) continue;
            remove.add(profile.getLongHash());
        }
        for (String hash : remove) {
            KnownUsers.removeByHash(hash, false);
        }
    }

    public static Profile add(String hash) {
        if (MineTogetherChat.INSTANCE == null) {
            return null;
        }
        if (MineTogetherChat.INSTANCE.hash.startsWith(hash.substring(2))) {
            return null;
        }
        Profile profile = new Profile(hash);
        if (KnownUsers.findByNick(hash) == null) {
            profiles.updateAndGet(profiles1 -> {
                profiles1.add(profile);
                return profiles1;
            });
            CompletableFuture.runAsync(() -> {
                Profile profileFuture = KnownUsers.findByNick(hash);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    profileFuture.loadProfile();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, MineTogetherChat.profileExecutor);
            return profile;
        }
        return null;
    }

    public static boolean update(Profile updatedProfile) {
        Profile finalProfile = null;
        if (updatedProfile.getLongHash().length() > 0) {
            profiles.updateAndGet(curProfiles -> {
                Profile existingProfile = KnownUsers.findByHash(updatedProfile.getLongHash());
                if (existingProfile == null) {
                    return curProfiles;
                }
                curProfiles.remove(existingProfile);
                curProfiles.add(updatedProfile);
                return curProfiles;
            });
            finalProfile = KnownUsers.findByHash(updatedProfile.getLongHash());
        } else if (updatedProfile.getMediumHash().length() > 0) {
            profiles.updateAndGet(curProfiles -> {
                Profile existingProfile = KnownUsers.findByNick(updatedProfile.getMediumHash());
                if (existingProfile == null) {
                    return curProfiles;
                }
                curProfiles.remove(existingProfile);
                curProfiles.add(updatedProfile);
                return curProfiles;
            });
            finalProfile = KnownUsers.findByNick(updatedProfile.getMediumHash());
        }
        return finalProfile != null && finalProfile == updatedProfile;
    }

    public static void removeByHash(String hash, boolean ignoreFriend) {
        profiles.updateAndGet(profiles1 -> {
            Profile profileTarget = KnownUsers.findByHash(hash);
            if (profileTarget == null) {
                return profiles1;
            }
            if (profileTarget.isBanned()) {
                return profiles1;
            }
            if (ignoreFriend && profileTarget.isFriend()) {
                return profiles1;
            }
            profiles1.remove(profileTarget);
            return profiles1;
        });
    }

    public static void removeByNick(String nick, boolean ignoreFriend) {
        profiles.updateAndGet(profiles1 -> {
            Profile profileTarget = KnownUsers.findByNick(nick);
            if (profileTarget == null) {
                return profiles1;
            }
            if (profileTarget.isBanned()) {
                return profiles1;
            }
            if (ignoreFriend && profileTarget.isFriend()) {
                return profiles1;
            }
            profiles1.remove(profileTarget);
            return profiles1;
        });
    }

    public static Profile findByHash(String search) {
        ArrayList profilesCopy = new ArrayList(profiles.get());
        Profile returnProfile = null;
        for (Profile profile : profilesCopy) {
            if (profile == null || profile.getShortHash() == null || profile.getMediumHash() == null || !profile.getLongHash().equalsIgnoreCase(search)) continue;
            returnProfile = profile;
            break;
        }
        return returnProfile;
    }

    public static Profile findByDisplay(String search) {
        ArrayList profilesCopy = new ArrayList(profiles.get());
        Profile returnProfile = null;
        for (Profile profile : profilesCopy) {
            if (profile == null || profile.getShortHash() == null || profile.getMediumHash() == null || !profile.getUserDisplay().equalsIgnoreCase(search)) continue;
            returnProfile = profile;
            break;
        }
        return returnProfile;
    }

    public static Profile findByNick(String search) {
        ArrayList profilesCopy = new ArrayList(profiles.get());
        Profile returnProfile = null;
        for (Profile profile : profilesCopy) {
            if (profile == null || profile.getShortHash() == null || profile.getMediumHash() == null || !profile.getShortHash().equalsIgnoreCase(search) && !profile.getMediumHash().equalsIgnoreCase(search)) continue;
            returnProfile = profile;
            break;
        }
        return returnProfile;
    }

    public static List<String> getNames() {
        ArrayList profilesCopy = new ArrayList(profiles.get());
        return profilesCopy.stream().map(Profile::getUserDisplay).collect(Collectors.toList());
    }

    public static List<Profile> getFriends() {
        ArrayList profilesCopy = new ArrayList(profiles.get());
        ArrayList<Profile> returnList = new ArrayList<Profile>();
        for (Profile profile : profilesCopy) {
            if (!profile.isFriend()) continue;
            returnList.add(profile);
        }
        return returnList;
    }

    public static List<Profile> getPending() {
        return profiles.get().stream().filter(Profile::isPending).collect(Collectors.toList());
    }

    public static List<Profile> getMuted() {
        ArrayList profilesCopy = new ArrayList(profiles.get());
        ArrayList<Profile> returnList = new ArrayList<Profile>();
        for (Profile profile : profilesCopy) {
            if (!profile.isMuted()) continue;
            returnList.add(profile);
        }
        return returnList;
    }

    public static List<Profile> getPartyMembers() {
        ArrayList profilesCopy = new ArrayList(profiles.get());
        ArrayList<Profile> returnList = new ArrayList<Profile>();
        for (Profile profile : profilesCopy) {
            if (!profile.isPartyMember()) continue;
            returnList.add(profile);
        }
        return returnList;
    }

    public static AtomicReference<List<Profile>> getProfiles() {
        return profiles;
    }

    static {
        profiles.set(new ArrayList());
        lastFriendsUpdate = 0L;
    }
}

