/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.io.sentry.transport;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.creeperhost.minetogether.io.sentry.ILogger;
import net.creeperhost.minetogether.io.sentry.SentryEnvelope;
import net.creeperhost.minetogether.io.sentry.SentryEnvelopeItem;
import net.creeperhost.minetogether.io.sentry.SentryLevel;
import net.creeperhost.minetogether.io.sentry.hints.Retryable;
import net.creeperhost.minetogether.io.sentry.hints.SubmissionResult;
import net.creeperhost.minetogether.io.sentry.transport.CurrentDateProvider;
import net.creeperhost.minetogether.io.sentry.transport.ICurrentDateProvider;
import net.creeperhost.minetogether.io.sentry.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RateLimiter {
    private static final int HTTP_RETRY_AFTER_DEFAULT_DELAY_MILLIS = 60000;
    @NotNull
    private final ICurrentDateProvider currentDateProvider;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final @NotNull Map<DataCategory, @NotNull Date> sentryRetryAfterLimit = new ConcurrentHashMap<DataCategory, Date>();

    public RateLimiter(@NotNull ICurrentDateProvider currentDateProvider, @NotNull ILogger logger) {
        this.currentDateProvider = currentDateProvider;
        this.logger = logger;
    }

    public RateLimiter(@NotNull ILogger logger) {
        this(CurrentDateProvider.getInstance(), logger);
    }

    @Nullable
    public SentryEnvelope filter(@NotNull SentryEnvelope envelope, @Nullable Object hint) {
        ArrayList<SentryEnvelopeItem> dropItems = null;
        for (SentryEnvelopeItem item : envelope.getItems()) {
            if (!this.isRetryAfter(item.getHeader().getType().getItemType())) continue;
            if (dropItems == null) {
                dropItems = new ArrayList<SentryEnvelopeItem>();
            }
            dropItems.add(item);
        }
        if (dropItems != null) {
            this.logger.log(SentryLevel.INFO, "%d items will be dropped due rate limiting.", dropItems.size());
            ArrayList<SentryEnvelopeItem> toSend = new ArrayList<SentryEnvelopeItem>();
            for (SentryEnvelopeItem item : envelope.getItems()) {
                if (dropItems.contains(item)) continue;
                toSend.add(item);
            }
            if (toSend.isEmpty()) {
                this.logger.log(SentryLevel.INFO, "Envelope discarded due all items rate limited.", new Object[0]);
                RateLimiter.markHintWhenSendingFailed(hint, false);
                return null;
            }
            return new SentryEnvelope(envelope.getHeader(), toSend);
        }
        return envelope;
    }

    private static void markHintWhenSendingFailed(@Nullable Object hint, boolean retry) {
        if (hint instanceof SubmissionResult) {
            ((SubmissionResult)hint).setResult(false);
        }
        if (hint instanceof Retryable) {
            ((Retryable)hint).setRetry(retry);
        }
    }

    private boolean isRetryAfter(@NotNull String itemType) {
        DataCategory dataCategory = this.getCategoryFromItemType(itemType);
        Date currentDate = new Date(this.currentDateProvider.getCurrentTimeMillis());
        Date dateAllCategories = this.sentryRetryAfterLimit.get((Object)DataCategory.All);
        if (dateAllCategories != null && !currentDate.after(dateAllCategories)) {
            return true;
        }
        if (DataCategory.Unknown.equals((Object)dataCategory)) {
            return false;
        }
        Date dateCategory = this.sentryRetryAfterLimit.get((Object)dataCategory);
        if (dateCategory != null) {
            return !currentDate.after(dateCategory);
        }
        return false;
    }

    @NotNull
    private DataCategory getCategoryFromItemType(@NotNull String itemType) {
        switch (itemType) {
            case "event": {
                return DataCategory.Error;
            }
            case "session": {
                return DataCategory.Session;
            }
            case "attachment": {
                return DataCategory.Attachment;
            }
            case "transaction": {
                return DataCategory.Transaction;
            }
        }
        return DataCategory.Unknown;
    }

    public void updateRetryAfterLimits(@Nullable String sentryRateLimitHeader, @Nullable String retryAfterHeader, int errorCode) {
        if (sentryRateLimitHeader != null) {
            for (String limit : sentryRateLimitHeader.split(",", -1)) {
                String[] retryAfterAndCategories = (limit = limit.replace(" ", "")).split(":", -1);
                if (retryAfterAndCategories.length <= 0) continue;
                String retryAfter = retryAfterAndCategories[0];
                long retryAfterMillis = this.parseRetryAfterOrDefault(retryAfter);
                if (retryAfterAndCategories.length <= 1) continue;
                String allCategories = retryAfterAndCategories[1];
                Date date = new Date(this.currentDateProvider.getCurrentTimeMillis() + retryAfterMillis);
                if (allCategories != null && !allCategories.isEmpty()) {
                    String[] categories;
                    for (String catItem : categories = allCategories.split(";", -1)) {
                        DataCategory dataCategory = DataCategory.Unknown;
                        try {
                            String catItemCapitalized = StringUtils.capitalize(catItem);
                            if (catItemCapitalized != null) {
                                dataCategory = DataCategory.valueOf(catItemCapitalized);
                            } else {
                                this.logger.log(SentryLevel.ERROR, "Couldn't capitalize: %s", catItem);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            this.logger.log(SentryLevel.INFO, e, "Unknown category: %s", catItem);
                        }
                        if (DataCategory.Unknown.equals((Object)dataCategory)) continue;
                        this.applyRetryAfterOnlyIfLonger(dataCategory, date);
                    }
                    continue;
                }
                this.applyRetryAfterOnlyIfLonger(DataCategory.All, date);
            }
        } else if (errorCode == 429) {
            long retryAfterMillis = this.parseRetryAfterOrDefault(retryAfterHeader);
            Date date = new Date(this.currentDateProvider.getCurrentTimeMillis() + retryAfterMillis);
            this.applyRetryAfterOnlyIfLonger(DataCategory.All, date);
        }
    }

    private void applyRetryAfterOnlyIfLonger(@NotNull DataCategory dataCategory, @NotNull Date date) {
        Date oldDate = this.sentryRetryAfterLimit.get((Object)dataCategory);
        if (oldDate == null || date.after(oldDate)) {
            this.sentryRetryAfterLimit.put(dataCategory, date);
        }
    }

    private long parseRetryAfterOrDefault(@Nullable String retryAfterHeader) {
        long retryAfterMillis = 60000L;
        if (retryAfterHeader != null) {
            try {
                retryAfterMillis = (long)(Double.parseDouble(retryAfterHeader) * 1000.0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retryAfterMillis;
    }

    private static enum DataCategory {
        All("__all__"),
        Default("default"),
        Error("error"),
        Session("session"),
        Attachment("attachment"),
        Transaction("transaction"),
        Security("security"),
        Unknown("unknown");

        private final String category;

        private DataCategory(String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }
    }
}

