/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.io.sentry.protocol;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.creeperhost.minetogether.io.sentry.Span;
import net.creeperhost.minetogether.io.sentry.SpanId;
import net.creeperhost.minetogether.io.sentry.SpanStatus;
import net.creeperhost.minetogether.io.sentry.protocol.SentryId;
import net.creeperhost.minetogether.io.sentry.util.CollectionUtils;
import net.creeperhost.minetogether.io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentrySpan {
    @NotNull
    private final Date startTimestamp;
    @Nullable
    private final Date timestamp;
    @NotNull
    private final SentryId traceId;
    @NotNull
    private final SpanId spanId;
    @Nullable
    private final SpanId parentSpanId;
    @NotNull
    private final String op;
    @Nullable
    private final String description;
    @Nullable
    private final SpanStatus status;
    @NotNull
    private final Map<String, String> tags;
    @Nullable
    private final Map<String, Object> data;

    public SentrySpan(@NotNull Span span) {
        this(span, span.getData());
    }

    @ApiStatus.Internal
    public SentrySpan(@NotNull Span span, @Nullable Map<String, Object> data) {
        Objects.requireNonNull(span, "span is required");
        this.description = span.getDescription();
        this.op = span.getOperation();
        this.spanId = span.getSpanId();
        this.parentSpanId = span.getParentSpanId();
        this.traceId = span.getTraceId();
        this.status = span.getStatus();
        ConcurrentHashMap tagsCopy = CollectionUtils.newConcurrentHashMap(span.getTags());
        this.tags = tagsCopy != null ? tagsCopy : new ConcurrentHashMap();
        this.timestamp = span.getTimestamp();
        this.startTimestamp = span.getStartTimestamp();
        this.data = data;
    }

    public boolean isFinished() {
        return this.timestamp != null;
    }

    @NotNull
    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    @Nullable
    public Date getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public SentryId getTraceId() {
        return this.traceId;
    }

    @NotNull
    public SpanId getSpanId() {
        return this.spanId;
    }

    @Nullable
    public SpanId getParentSpanId() {
        return this.parentSpanId;
    }

    @NotNull
    public String getOp() {
        return this.op;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public SpanStatus getStatus() {
        return this.status;
    }

    @NotNull
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Nullable
    public Map<String, Object> getData() {
        return this.data;
    }
}

