/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.io.sentry.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.creeperhost.minetogether.io.sentry.ILogger;
import net.creeperhost.minetogether.io.sentry.SentryLevel;
import net.creeperhost.minetogether.io.sentry.config.PropertiesLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FilesystemPropertiesLoader
implements PropertiesLoader {
    @NotNull
    private final String filePath;
    @NotNull
    private final ILogger logger;

    public FilesystemPropertiesLoader(@NotNull String filePath, @NotNull ILogger logger) {
        this.filePath = filePath;
        this.logger = logger;
    }

    @Override
    @Nullable
    public Properties load() {
        block7: {
            Properties properties;
            File f = new File(this.filePath);
            if (!f.isFile() || !f.canRead()) break block7;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
            try {
                Properties properties2 = new Properties();
                properties2.load(is);
                properties = properties2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.logger.log(SentryLevel.ERROR, e, "Failed to load Sentry configuration from file: %s", this.filePath);
                    return null;
                }
            }
            ((InputStream)is).close();
            return properties;
        }
        return null;
    }
}

