/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.io.sentry;

import java.util.concurrent.Callable;
import net.creeperhost.minetogether.io.sentry.SentryItemType;
import net.creeperhost.minetogether.io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryEnvelopeItemHeader {
    @Nullable
    private final String contentType;
    @Nullable
    private final String fileName;
    @NotNull
    private final SentryItemType type;
    private final int length;
    @Nullable
    private final Callable<Integer> getLength;
    @Nullable
    private final String attachmentType;

    @NotNull
    public SentryItemType getType() {
        return this.type;
    }

    public int getLength() {
        if (this.getLength != null) {
            try {
                return this.getLength.call();
            }
            catch (Throwable ignored) {
                return -1;
            }
        }
        return this.length;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    SentryEnvelopeItemHeader(@NotNull SentryItemType type, int length, @Nullable String contentType, @Nullable String fileName, @Nullable String attachmentType) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.contentType = contentType;
        this.length = length;
        this.fileName = fileName;
        this.getLength = null;
        this.attachmentType = attachmentType;
    }

    SentryEnvelopeItemHeader(@NotNull SentryItemType type, @Nullable Callable<Integer> getLength, @Nullable String contentType, @Nullable String fileName, @Nullable String attachmentType) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.contentType = contentType;
        this.length = -1;
        this.fileName = fileName;
        this.getLength = getLength;
        this.attachmentType = attachmentType;
    }

    SentryEnvelopeItemHeader(@NotNull SentryItemType type, @Nullable Callable<Integer> getLength, @Nullable String contentType, @Nullable String fileName) {
        this(type, getLength, contentType, fileName, null);
    }

    @Nullable
    public String getAttachmentType() {
        return this.attachmentType;
    }
}

