/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.io.sentry;

import java.util.Date;
import net.creeperhost.minetogether.io.sentry.ISpan;
import net.creeperhost.minetogether.io.sentry.SentryTraceHeader;
import net.creeperhost.minetogether.io.sentry.SpanContext;
import net.creeperhost.minetogether.io.sentry.SpanId;
import net.creeperhost.minetogether.io.sentry.SpanStatus;
import net.creeperhost.minetogether.io.sentry.TraceState;
import net.creeperhost.minetogether.io.sentry.TraceStateHeader;
import net.creeperhost.minetogether.io.sentry.protocol.SentryId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NoOpSpan
implements ISpan {
    private static final NoOpSpan instance = new NoOpSpan();

    private NoOpSpan() {
    }

    public static NoOpSpan getInstance() {
        return instance;
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation) {
        return NoOpSpan.getInstance();
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @Nullable Date timestamp) {
        return NoOpSpan.getInstance();
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description) {
        return NoOpSpan.getInstance();
    }

    @Override
    @NotNull
    public SentryTraceHeader toSentryTrace() {
        return new SentryTraceHeader(SentryId.EMPTY_ID, SpanId.EMPTY_ID, false);
    }

    @Override
    @NotNull
    public TraceState traceState() {
        return new TraceState(SentryId.EMPTY_ID, "");
    }

    @Override
    @NotNull
    public TraceStateHeader toTraceStateHeader() {
        return new TraceStateHeader("");
    }

    @Override
    public void finish() {
    }

    @Override
    public void finish(@Nullable SpanStatus status) {
    }

    @Override
    public void setOperation(@NotNull String operation) {
    }

    @Override
    @NotNull
    public String getOperation() {
        return "";
    }

    @Override
    public void setDescription(@Nullable String description) {
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    public void setStatus(@Nullable SpanStatus status) {
    }

    @Override
    @Nullable
    public SpanStatus getStatus() {
        return null;
    }

    @Override
    public void setThrowable(@Nullable Throwable throwable) {
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return null;
    }

    @Override
    @NotNull
    public SpanContext getSpanContext() {
        return new SpanContext(SentryId.EMPTY_ID, SpanId.EMPTY_ID, "op", null, null);
    }

    @Override
    public void setTag(@NotNull String key, @NotNull String value) {
    }

    @Override
    @Nullable
    public String getTag(@NotNull String key) {
        return null;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public void setData(@NotNull String key, @NotNull Object value) {
    }

    @Override
    @Nullable
    public Object getData(@NotNull String key) {
        return null;
    }
}

