/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.io.sentry;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import net.creeperhost.minetogether.io.sentry.ISerializer;
import net.creeperhost.minetogether.io.sentry.SentryEnvelope;
import net.creeperhost.minetogether.io.sentry.SentryEnvelopeHeader;
import net.creeperhost.minetogether.io.sentry.SentryEnvelopeHeaderAdapter;
import net.creeperhost.minetogether.io.sentry.SentryEnvelopeItem;
import net.creeperhost.minetogether.io.sentry.SentryEnvelopeItemHeader;
import net.creeperhost.minetogether.io.sentry.SentryEnvelopeItemHeaderAdapter;
import net.creeperhost.minetogether.io.sentry.SentryLevel;
import net.creeperhost.minetogether.io.sentry.SentryOptions;
import net.creeperhost.minetogether.io.sentry.Session;
import net.creeperhost.minetogether.io.sentry.SessionAdapter;
import net.creeperhost.minetogether.io.sentry.SpanId;
import net.creeperhost.minetogether.io.sentry.SpanStatus;
import net.creeperhost.minetogether.io.sentry.UnknownPropertiesTypeAdapterFactory;
import net.creeperhost.minetogether.io.sentry.adapters.CollectionAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.ContextsDeserializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.ContextsSerializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.DateDeserializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.DateSerializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.MapAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.OrientationDeserializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.OrientationSerializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.SentryIdDeserializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.SentryIdSerializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.SentryLevelDeserializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.SentryLevelSerializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.SpanIdDeserializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.SpanIdSerializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.SpanStatusDeserializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.SpanStatusSerializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.TimeZoneDeserializerAdapter;
import net.creeperhost.minetogether.io.sentry.adapters.TimeZoneSerializerAdapter;
import net.creeperhost.minetogether.io.sentry.protocol.Contexts;
import net.creeperhost.minetogether.io.sentry.protocol.Device;
import net.creeperhost.minetogether.io.sentry.protocol.SentryId;
import net.creeperhost.minetogether.io.sentry.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GsonSerializer
implements ISerializer {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final Gson gson;

    public GsonSerializer(@NotNull SentryOptions options) {
        this.options = Objects.requireNonNull(options, "The SentryOptions object is required.");
        this.gson = this.provideGson();
    }

    @NotNull
    private Gson provideGson() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(SentryId.class, (Object)new SentryIdSerializerAdapter(this.options)).registerTypeAdapter(SentryId.class, (Object)new SentryIdDeserializerAdapter(this.options)).registerTypeAdapter(Date.class, (Object)new DateSerializerAdapter(this.options)).registerTypeAdapter(Date.class, (Object)new DateDeserializerAdapter(this.options)).registerTypeAdapter(TimeZone.class, (Object)new TimeZoneSerializerAdapter(this.options)).registerTypeAdapter(TimeZone.class, (Object)new TimeZoneDeserializerAdapter(this.options)).registerTypeAdapter(Device.DeviceOrientation.class, (Object)new OrientationSerializerAdapter(this.options)).registerTypeAdapter(Device.DeviceOrientation.class, (Object)new OrientationDeserializerAdapter(this.options)).registerTypeAdapter(SentryLevel.class, (Object)new SentryLevelSerializerAdapter(this.options)).registerTypeAdapter(SentryLevel.class, (Object)new SentryLevelDeserializerAdapter(this.options)).registerTypeAdapter(Contexts.class, (Object)new ContextsDeserializerAdapter(this.options)).registerTypeAdapter(Contexts.class, (Object)new ContextsSerializerAdapter(this.options)).registerTypeAdapterFactory(UnknownPropertiesTypeAdapterFactory.get()).registerTypeAdapter(SentryEnvelopeHeader.class, (Object)new SentryEnvelopeHeaderAdapter()).registerTypeAdapter(SentryEnvelopeItemHeader.class, (Object)new SentryEnvelopeItemHeaderAdapter()).registerTypeAdapter(Session.class, (Object)new SessionAdapter(this.options)).registerTypeAdapter(SpanId.class, (Object)new SpanIdDeserializerAdapter(this.options)).registerTypeAdapter(SpanId.class, (Object)new SpanIdSerializerAdapter(this.options)).registerTypeAdapter(SpanStatus.class, (Object)new SpanStatusDeserializerAdapter(this.options)).registerTypeAdapter(SpanStatus.class, (Object)new SpanStatusSerializerAdapter(this.options)).registerTypeHierarchyAdapter(Collection.class, (Object)new CollectionAdapter()).registerTypeHierarchyAdapter(Map.class, (Object)new MapAdapter()).disableHtmlEscaping().create();
    }

    @Override
    @Nullable
    public <T> T deserialize(@NotNull Reader reader, @NotNull Class<T> clazz) {
        Objects.requireNonNull(reader, "The Reader object is required.");
        Objects.requireNonNull(clazz, "The Class type is required.");
        return (T)this.gson.fromJson(reader, clazz);
    }

    @Override
    @Nullable
    public SentryEnvelope deserializeEnvelope(@NotNull InputStream inputStream) {
        Objects.requireNonNull(inputStream, "The InputStream object is required.");
        try {
            return this.options.getEnvelopeReader().read(inputStream);
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error deserializing envelope.", e);
            return null;
        }
    }

    @Override
    public <T> void serialize(@NotNull T entity, @NotNull Writer writer) throws IOException {
        Objects.requireNonNull(entity, "The entity is required.");
        Objects.requireNonNull(writer, "The Writer object is required.");
        if (this.options.getLogger().isEnabled(SentryLevel.DEBUG)) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Serializing object: %s", this.gson.toJson(entity));
        }
        this.gson.toJson(entity, entity.getClass(), (Appendable)writer);
        writer.flush();
    }

    @Override
    public void serialize(@NotNull SentryEnvelope envelope, @NotNull OutputStream outputStream) throws Exception {
        Objects.requireNonNull(envelope, "The SentryEnvelope object is required.");
        Objects.requireNonNull(outputStream, "The Stream object is required.");
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, UTF_8));){
            this.gson.toJson((Object)envelope.getHeader(), SentryEnvelopeHeader.class, (Appendable)writer);
            writer.write("\n");
            for (SentryEnvelopeItem item : envelope.getItems()) {
                try {
                    byte[] data = item.getData();
                    this.gson.toJson((Object)item.getHeader(), SentryEnvelopeItemHeader.class, (Appendable)writer);
                    writer.write("\n");
                    ((Writer)writer).flush();
                    outputStream.write(data);
                    writer.write("\n");
                }
                catch (Throwable exception) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to create envelope item. Dropping it.", exception);
                }
            }
            ((Writer)writer).flush();
        }
    }

    @Override
    @NotNull
    public String serialize(@NotNull Map<String, Object> data) throws Exception {
        Objects.requireNonNull(data, "The SentryEnvelope object is required.");
        return this.gson.toJson(data);
    }
}

