/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.handler;

import java.util.ArrayList;
import net.creeperhost.minetogether.MineTogetherServer;
import net.creeperhost.minetogether.lib.serverorder.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class PregenTask {
    public boolean preventJoin = true;
    public ResourceKey<Level> dimension;
    public transient ArrayList<Pair<Integer, Integer>> chunksToGen;
    public int chunksPerTick;
    public int storedCurX;
    public int storedCurZ;
    public int minX;
    public int maxX;
    public int minZ;
    public int maxZ;
    public int diameterX = 0;
    public int diameterZ = 0;
    public long startTime = 0L;
    public transient long lastCheckedTime = -9001L;
    public int chunksDone = 0;
    public int totalChunks = 0;
    public transient int lastChunksDone = 0;
    public transient String lastPregenString = "No status yet!";
    public transient int chunkLoadCount;
    public transient int curChunksPerTick;

    public PregenTask(ResourceKey<Level> dimension, int minX, int maxX, int minZ, int maxZ, int chunksPerTick, boolean preventJoin) {
        this.dimension = dimension;
        this.chunksPerTick = chunksPerTick;
        this.minX = minX;
        this.maxX = maxX;
        this.minZ = minZ;
        this.maxZ = maxZ;
        this.storedCurX = minX;
        this.storedCurZ = minZ;
        this.preventJoin = preventJoin;
        this.init();
    }

    public void init() {
        this.startTime = 0L;
        if (this.chunksToGen != null) {
            return;
        }
        ServerLevel world = MineTogetherServer.minecraftServer.m_129880_(this.dimension);
        if (this.diameterX > 0 && this.totalChunks == 0) {
            BlockPos pos = world.m_8900_();
            this.minX = (pos.m_123341_() << 4) - this.diameterX / 2;
            this.maxX = (pos.m_123341_() << 4) + this.diameterX / 2;
            this.minZ = (pos.m_123343_() << 4) - this.diameterZ / 2;
            this.maxZ = (pos.m_123343_() << 4) + this.diameterZ / 2;
            this.storedCurX = this.minX;
            this.storedCurZ = this.minZ;
        }
        this.chunksDone = 0;
        this.totalChunks = 0;
        this.chunkLoadCount = world.m_7726_().m_142061_();
        ArrayList<Pair<Integer, Integer>> chunks = new ArrayList<Pair<Integer, Integer>>();
        for (int curX = this.minX; curX <= this.maxX; ++curX) {
            if (curX < this.storedCurX) continue;
            for (int curZ = this.minZ; curZ <= this.maxZ; ++curZ) {
                if (curX == this.storedCurX && curZ <= this.storedCurZ) continue;
                chunks.add(new Pair<Integer, Integer>(curX, curZ));
                ++this.totalChunks;
            }
        }
        this.chunksToGen = chunks;
        this.curChunksPerTick = this.chunksPerTick;
    }
}

