/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import net.creeperhost.minetogether.MineTogetherCommon;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import org.apache.commons.io.IOUtils;

public class Config {
    private transient String version;
    public String curseProjectID;
    private String promoCode;
    private boolean creeperhostEnabled;
    private boolean mpMenuEnabled;
    private boolean mainMenuEnabled;
    private boolean serverHostButtonImage;
    private boolean serverHostMenuImage;
    private boolean sivIntegration;
    private boolean serverListEnabled;
    private boolean chatEnabled;
    private boolean autoMT;
    private boolean enableFriendOnlineToasts;
    private boolean enableMainMenuFriends;
    private boolean replaceRealms;
    private transient boolean argChatDisable;
    private String issueTrackerUrl;
    private String firstConnect = "";
    private boolean debugMode;
    private boolean optOutSentry;
    private int pregenDiameter = 120;
    public static Config instance;

    public Config() {
        this.version = "0";
        this.curseProjectID = "Insert curse project ID here";
        this.promoCode = "Insert Promo Code here";
        this.creeperhostEnabled = true;
        this.mpMenuEnabled = true;
        this.mainMenuEnabled = true;
        this.serverHostButtonImage = true;
        this.serverHostMenuImage = true;
        this.sivIntegration = true;
        this.serverListEnabled = true;
        this.chatEnabled = true;
        this.autoMT = true;
        this.enableFriendOnlineToasts = true;
        this.enableMainMenuFriends = true;
        this.replaceRealms = true;
        this.issueTrackerUrl = "https://pste.ch/";
        this.debugMode = false;
        this.optOutSentry = true;
    }

    private Config(String version, String promoCode, boolean creeperhostEnabled, boolean mpMenuEnabled, boolean mainMenuEnabled, boolean serverHostButtonImage, boolean serverHostMenuImage) {
        this.version = version;
        this.promoCode = promoCode;
        this.creeperhostEnabled = creeperhostEnabled;
        this.mpMenuEnabled = mpMenuEnabled;
        this.mainMenuEnabled = mainMenuEnabled;
        this.serverHostButtonImage = serverHostButtonImage;
        this.serverHostMenuImage = serverHostMenuImage;
        this.argChatDisable = System.getProperty("mt.disablechat").equalsIgnoreCase("true");
    }

    public static Config getInstance() {
        return instance;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPromo() {
        return this.promoCode;
    }

    public boolean isSivIntegration() {
        return this.sivIntegration;
    }

    public boolean isMpMenuEnabled() {
        return this.mpMenuEnabled;
    }

    public boolean isCreeperhostEnabled() {
        return this.creeperhostEnabled;
    }

    public boolean isMainMenuEnabled() {
        return this.mainMenuEnabled;
    }

    public boolean isServerHostButtonImage() {
        return this.serverHostButtonImage;
    }

    public boolean isServerHostMenuImage() {
        return this.serverHostMenuImage;
    }

    public boolean isServerListEnabled() {
        return this.serverListEnabled;
    }

    public int getPregenDiameter() {
        return this.pregenDiameter;
    }

    public void setMpMenuEnabled(boolean value) {
        this.mpMenuEnabled = value;
    }

    public void setServerListEnabled(boolean value) {
        this.serverListEnabled = value;
    }

    public void setChatEnabled(boolean value) {
        this.chatEnabled = value;
    }

    public void setEnableFriendOnlineToasts(boolean enableFriendOnlineToasts) {
        this.enableFriendOnlineToasts = enableFriendOnlineToasts;
    }

    public boolean isChatEnabled() {
        return this.chatEnabled && !this.argChatDisable;
    }

    public boolean isOptOutSentry() {
        return this.optOutSentry;
    }

    public boolean getFirstConnect() {
        Profile self;
        boolean response = true;
        if (MineTogetherChat.profile != null && (self = MineTogetherChat.profile.get()) != null) {
            boolean bl = response = !self.hasAccount();
        }
        if (response) {
            response = !this.firstConnect.equalsIgnoreCase(MineTogetherChat.INSTANCE.ourNick);
        }
        return response;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setFirstConnect(boolean first) {
        this.firstConnect = first ? "" : MineTogetherChat.INSTANCE.ourNick;
        Config.saveConfigToFile(MineTogetherCommon.configFile.toFile());
    }

    public boolean isFriendOnlineToastsEnabled() {
        return this.enableFriendOnlineToasts;
    }

    public String getCurseProjectID() {
        return this.curseProjectID;
    }

    public boolean isAutoMT() {
        return this.autoMT;
    }

    public boolean isEnableMainMenuFriends() {
        return this.enableMainMenuFriends;
    }

    public boolean getReplaceRealms() {
        return this.replaceRealms;
    }

    public void setEnableMainMenuFriends(boolean enableMainMenuFriends) {
        this.enableMainMenuFriends = enableMainMenuFriends;
    }

    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public static void loadFromFile(File file) {
        Gson gson = new Gson();
        try {
            FileReader fileReader = new FileReader(file);
            instance = (Config)gson.fromJson((Reader)fileReader, Config.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveConfigToFile(File file) {
        try (FileOutputStream configOut = new FileOutputStream(file);){
            IOUtils.write((String)Config.saveConfig(), (OutputStream)configOut, (Charset)Charset.defaultCharset());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String saveConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return gson.toJson((Object)instance);
    }

    public static void init(File file) {
        try {
            if (!file.exists()) {
                instance = new Config();
                FileWriter tileWriter = new FileWriter(file);
                tileWriter.write(Config.saveConfig());
                tileWriter.close();
            } else {
                Config.loadFromFile(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

