/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.core.services;

import net.creeperhost.minetogether.com.github.scribejava.core.exceptions.OAuthSignatureException;
import net.creeperhost.minetogether.com.github.scribejava.core.services.SignatureService;
import net.creeperhost.minetogether.com.github.scribejava.core.utils.OAuthEncoder;
import net.creeperhost.minetogether.com.github.scribejava.core.utils.Preconditions;

public class PlaintextSignatureService
implements SignatureService {
    private static final String METHOD = "PLAINTEXT";

    @Override
    public String getSignature(String baseString, String apiSecret, String tokenSecret) {
        try {
            Preconditions.checkEmptyString(apiSecret, "Api secret cant be null or empty string");
            return OAuthEncoder.encode(apiSecret) + '&' + OAuthEncoder.encode(tokenSecret);
        }
        catch (Exception e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    @Override
    public String getSignatureMethod() {
        return METHOD;
    }
}

