/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.core.model;

import net.creeperhost.minetogether.com.github.scribejava.core.model.Token;
import net.creeperhost.minetogether.com.github.scribejava.core.utils.Preconditions;

public abstract class OAuth1Token
extends Token {
    private static final long serialVersionUID = 6285873427974823019L;
    private final String token;
    private final String tokenSecret;

    public OAuth1Token(String token, String tokenSecret, String rawResponse) {
        super(rawResponse);
        Preconditions.checkNotNull(token, "oauth_token can't be null");
        Preconditions.checkNotNull(tokenSecret, "oauth_token_secret can't be null");
        this.token = token;
        this.tokenSecret = tokenSecret;
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public boolean isEmpty() {
        return "".equals(this.token) && "".equals(this.tokenSecret);
    }
}

