/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.apis.imgur;

import java.io.OutputStream;
import net.creeperhost.minetogether.com.github.scribejava.apis.ImgurApi;
import net.creeperhost.minetogether.com.github.scribejava.core.builder.api.DefaultApi20;
import net.creeperhost.minetogether.com.github.scribejava.core.httpclient.HttpClient;
import net.creeperhost.minetogether.com.github.scribejava.core.httpclient.HttpClientConfig;
import net.creeperhost.minetogether.com.github.scribejava.core.model.OAuthRequest;
import net.creeperhost.minetogether.com.github.scribejava.core.oauth.AccessTokenRequestParams;
import net.creeperhost.minetogether.com.github.scribejava.core.oauth.OAuth20Service;

public class ImgurOAuthService
extends OAuth20Service {
    public ImgurOAuthService(ImgurApi api, String apiKey, String apiSecret, String callback, String defaultScope, String responseType, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        super(api, apiKey, apiSecret, callback, defaultScope, responseType, debugStream, userAgent, httpClientConfig, httpClient);
    }

    @Override
    protected OAuthRequest createAccessTokenRequest(AccessTokenRequestParams params) {
        DefaultApi20 api = this.getApi();
        OAuthRequest request = new OAuthRequest(api.getAccessTokenVerb(), api.getAccessTokenEndpoint());
        request.addBodyParameter("client_id", this.getApiKey());
        request.addBodyParameter("client_secret", this.getApiSecret());
        String oauthVerifier = params.getCode();
        if (ImgurApi.isOob(this.getCallback())) {
            request.addBodyParameter("grant_type", "pin");
            request.addBodyParameter("pin", oauthVerifier);
        } else {
            request.addBodyParameter("grant_type", "authorization_code");
            request.addBodyParameter("code", oauthVerifier);
        }
        String pkceCodeVerifier = params.getPkceCodeVerifier();
        if (pkceCodeVerifier != null) {
            request.addParameter("code_verifier", pkceCodeVerifier);
        }
        return request;
    }

    @Override
    public void signRequest(String accessToken, OAuthRequest request) {
        request.addHeader("Authorization", accessToken == null ? "Client-ID " + this.getApiKey() : "Bearer " + accessToken);
    }
}

