/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.apis.fitbit;

import java.io.IOException;
import net.creeperhost.minetogether.com.fasterxml.jackson.databind.JsonNode;
import net.creeperhost.minetogether.com.github.scribejava.apis.fitbit.FitBitOAuth2AccessToken;
import net.creeperhost.minetogether.com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import net.creeperhost.minetogether.com.github.scribejava.core.model.OAuth2AccessTokenErrorResponse;
import net.creeperhost.minetogether.com.github.scribejava.core.oauth2.OAuth2Error;

public class FitBitJsonTokenExtractor
extends OAuth2AccessTokenJsonExtractor {
    protected FitBitJsonTokenExtractor() {
    }

    public static FitBitJsonTokenExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    protected FitBitOAuth2AccessToken createToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, JsonNode response, String rawResponse) {
        return new FitBitOAuth2AccessToken(accessToken, tokenType, expiresIn, refreshToken, scope, response.get("user_id").asText(), rawResponse);
    }

    @Override
    public void generateError(String rawResponse) throws IOException {
        OAuth2Error errorCode;
        JsonNode errorNode = OAuth2AccessTokenJsonExtractor.OBJECT_MAPPER.readTree(rawResponse).get("errors").get(0);
        try {
            errorCode = OAuth2Error.parseFrom(FitBitJsonTokenExtractor.extractRequiredParameter(errorNode, "errorType", rawResponse).asText());
        }
        catch (IllegalArgumentException iaE) {
            errorCode = null;
        }
        throw new OAuth2AccessTokenErrorResponse(errorCode, errorNode.get("message").asText(), null, rawResponse);
    }

    private static class InstanceHolder {
        private static final FitBitJsonTokenExtractor INSTANCE = new FitBitJsonTokenExtractor();

        private InstanceHolder() {
        }
    }
}

