/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.apis;

import net.creeperhost.minetogether.com.github.scribejava.core.builder.api.DefaultApi10a;

public class FlickrApi
extends DefaultApi10a {
    private static final String AUTHORIZE_URL = "https://www.flickr.com/services/oauth/authorize";
    private final String permString;

    protected FlickrApi() {
        this.permString = null;
    }

    protected FlickrApi(FlickrPerm perm) {
        this.permString = perm.name().toLowerCase();
    }

    public static FlickrApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public static FlickrApi instance(FlickrPerm perm) {
        return perm == null ? FlickrApi.instance() : new FlickrApi(perm);
    }

    @Override
    public String getAccessTokenEndpoint() {
        return "https://www.flickr.com/services/oauth/access_token";
    }

    @Override
    public String getAuthorizationBaseUrl() {
        return this.permString == null ? AUTHORIZE_URL : "https://www.flickr.com/services/oauth/authorize?perms=" + this.permString;
    }

    @Override
    public String getRequestTokenEndpoint() {
        return "https://www.flickr.com/services/oauth/request_token";
    }

    private static class InstanceHolder {
        private static final FlickrApi INSTANCE = new FlickrApi();

        private InstanceHolder() {
        }
    }

    public static enum FlickrPerm {
        READ,
        WRITE,
        DELETE;

    }
}

