/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether;

import com.mojang.logging.LogUtils;
import dev.architectury.platform.Platform;
import java.nio.file.Path;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.MineTogetherServer;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.io.sentry.Sentry;
import net.creeperhost.minetogether.lib.chat.ChatConnectionStatus;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.logging.Log4jUtils;
import net.minecraftforge.api.distmarker.Dist;
import org.slf4j.Logger;

public class MineTogetherCommon {
    public static Logger logger = LogUtils.getLogger();
    public static String base64 = "";
    public static Path configFile = Platform.getConfigFolder().resolve("minetogether.json");

    public static void init() {
        Log4jUtils.attachMTLogs(Platform.getGameFolder().resolve("logs"));
        Config.init(configFile.toFile());
        if (!Config.getInstance().isOptOutSentry()) {
            Sentry.init(options -> {
                options.setDsn("https://07fc3e3411eb4c44849d2eb1faa28092@sentry.creeperhost.net/7");
                options.setTracesSampleRate(Platform.isDevelopmentEnvironment() ? 1.0 : 0.025);
                options.setEnvironment(Platform.getMinecraftVersion());
                options.setRelease("5.2.0");
                options.setTag("modloader", Platform.isForge() ? "forge" : "fabric");
                options.setTag("ram", String.valueOf(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
                options.setDist(System.getProperty("os.arch"));
                options.setServerName(Platform.getEnv() == Dist.CLIENT ? "integrated" : "dedicated");
                options.setDebug(Platform.isDevelopmentEnvironment());
                options.addInAppInclude("net.creeperhost.minetogether");
            });
        }
        try {
            MineTogetherChat.DEBUG_MODE = Config.getInstance().isDebugMode();
            if (Platform.getEnv() == Dist.CLIENT) {
                MineTogetherClient.init();
            }
            if (Platform.getEnv() == Dist.DEDICATED_SERVER) {
                MineTogetherServer.init();
            }
        }
        catch (Exception e) {
            Sentry.captureException(e);
        }
    }

    public static void sentryException(Throwable throwable) {
        Sentry.setTag("verified", ChatHandler.connectionStatus == ChatConnectionStatus.VERIFIED ? "true" : "false");
        Sentry.setTag("banned", ChatHandler.connectionStatus == ChatConnectionStatus.BANNED ? "true" : "false");
        Sentry.captureException(throwable);
    }
}

