/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.io.File;
import java.util.UUID;
import net.creeperhost.minetogether.MineTogetherCommon;
import net.creeperhost.minetogether.handler.AutoServerConnectHandler;
import net.creeperhost.minetogether.io.sentry.Sentry;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.irc.IrcHandler;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.module.chat.screen.social.MineTogetherSocialInteractionsScreen;
import net.creeperhost.minetogether.module.connect.ConnectModule;
import net.creeperhost.minetogether.module.multiplayer.MultiPlayerModule;
import net.creeperhost.minetogether.module.serverorder.ServerOrderModule;
import net.creeperhost.minetogether.screen.OfflineScreen;
import net.creeperhost.minetogether.threads.FriendUpdateThread;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.codec.digest.DigestUtils;

public class MineTogetherClient {
    public static boolean isOnlineUUID = false;
    public static final KeyMapping mtSocialKey = new KeyMapping(I18n.m_118938_((String)"minetogether.keybindings.social", (Object[])new Object[0]), InputConstants.Type.KEYSYM, 80, I18n.m_118938_((String)"minetogether.keybindings.category", (Object[])new Object[0]));
    static boolean firstOpen = true;

    public static void init() {
        try {
            ClientGuiEvent.INIT_POST.register(MineTogetherClient::onScreenOpen);
            ClientRawInputEvent.KEY_PRESSED.register(MineTogetherClient::onRawInput);
            ConnectModule.init();
            MineTogetherClient.getUUID();
            ChatModule.init();
            MineTogetherClient.registerKeybindings();
            if (!isOnlineUUID) {
                MineTogetherCommon.logger.info("minetogether Has detected profile is in offline mode");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                MineTogetherCommon.logger.info("Shutdown called, Stopping our threads");
                IrcHandler.sendString("QUIT Game closed", false);
                IrcHandler.stop(true);
                FriendUpdateThread.stop();
            }));
        }
        catch (Exception e) {
            Sentry.captureException(e);
        }
    }

    private static EventResult onRawInput(Minecraft minecraft, int keyCode, int scanCode, int action, int modifiers) {
        try {
            if (minecraft.f_91080_ == null && mtSocialKey.m_90857_()) {
                minecraft.m_91152_((Screen)new MineTogetherSocialInteractionsScreen());
                return EventResult.pass();
            }
            return EventResult.pass();
        }
        catch (Exception e) {
            Sentry.captureException(e);
            return EventResult.pass();
        }
    }

    public static void registerKeybindings() {
        KeyMappingRegistry.register((KeyMapping)mtSocialKey);
    }

    public static void removeVanillaSocialKeybinding() {
        Minecraft.m_91087_().f_91066_.f_92101_.m_90848_(InputConstants.f_84822_);
        KeyMapping.m_90854_();
    }

    public static UUID getUUID() {
        User session = Minecraft.m_91087_().m_91094_();
        UUID uuid = Minecraft.m_91087_().m_91094_().m_92548_().getId();
        isOnlineUUID = !uuid.equals(Player.m_36283_((String)session.m_92546_()));
        return uuid;
    }

    public static String getPlayerHash() {
        return ChatCallbacks.getPlayerHash(MineTogetherClient.getUUID());
    }

    public static String getServerIDAndVerify() {
        Minecraft mc = Minecraft.m_91087_();
        String serverId = DigestUtils.sha1Hex((String)UUID.randomUUID().toString());
        try {
            mc.m_91108_().joinServer(mc.m_91094_().m_92548_(), mc.m_91094_().m_92547_(), serverId);
        }
        catch (AuthenticationException e) {
            MineTogetherCommon.logger.error("Failed to get serverID from Mojang", (Throwable)e);
            return null;
        }
        MineTogetherCommon.logger.info("new ServerID requested");
        return serverId;
    }

    private static void onScreenOpen(Screen screen, ScreenAccess screenAccess) {
        try {
            if (firstOpen && screen instanceof TitleScreen) {
                ChatCallbacks.updateOnlineCount();
                MineTogetherClient.removeVanillaSocialKeybinding();
                File offline = new File("local/minetogether/offline.txt");
                if (!isOnlineUUID && !offline.exists()) {
                    Minecraft.m_91087_().m_91152_((Screen)new OfflineScreen());
                }
                firstOpen = false;
            }
            MultiPlayerModule.onScreenOpen(screen, screenAccess);
            ServerOrderModule.onScreenOpen(screen, screenAccess);
            ChatModule.onScreenOpen(screen, screenAccess);
            AutoServerConnectHandler.onScreenOpen(screen, screenAccess);
        }
        catch (Exception e) {
            Sentry.captureException(e);
        }
    }
}

