/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.configuration;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import technicianlp.reauth.configuration.Config;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.configuration.ProfileKeyComparator;

public final class ProfileList {
    private final Config configuration;
    private final ForgeConfigSpec.ConfigValue<List<CommentedConfig>> profilesProperty;
    private Supplier<CommentedConfig> configSupplier = TomlFormat::newConfig;

    ProfileList(Config configuration, ForgeConfigSpec.Builder builder) {
        this.configuration = configuration;
        this.profilesProperty = builder.comment("Saved Profiles. Check Documentation for Info & Syntax").define("profiles", this::createDefaultProfileList, this::validateProfileList);
    }

    final void updateConfig(ModConfig config) {
        this.configSupplier = () -> ((CommentedConfig)config.getConfigData()).createSubConfig();
        ArrayList<CommentedConfig> list = new ArrayList<CommentedConfig>((Collection)this.profilesProperty.get());
        this.correctProfiles(list);
        this.saveProfiles(list);
    }

    public final void storeProfile(Profile profile) {
        ArrayList<CommentedConfig> list = new ArrayList<CommentedConfig>((Collection)this.profilesProperty.get());
        if (list.isEmpty()) {
            list.add(profile.getConfig());
        } else {
            list.set(0, profile.getConfig());
        }
        this.saveProfiles(list);
    }

    public final Profile getProfile() {
        List list = (List)this.profilesProperty.get();
        if (list.isEmpty()) {
            return null;
        }
        CommentedConfig config = (CommentedConfig)list.get(0);
        String profileType = (String)config.getOrElse("type", (Object)"none");
        if (!"none".equals(profileType)) {
            return new Profile(config);
        }
        return null;
    }

    final Profile createProfile(Map<String, String> data) {
        TreeMap<String, String> orderedData = new TreeMap<String, String>(new ProfileKeyComparator());
        orderedData.putAll(data);
        CommentedConfig config = this.configSupplier.get();
        orderedData.forEach((arg_0, arg_1) -> ((CommentedConfig)config).set(arg_0, arg_1));
        return new Profile(config);
    }

    private void correctProfiles(List<CommentedConfig> profileList) {
        for (CommentedConfig profile : profileList) {
            Iterator iterator = profile.entrySet().iterator();
            while (iterator.hasNext()) {
                CommentedConfig.Entry entry = (CommentedConfig.Entry)iterator.next();
                Object value = entry.getValue();
                if (value == null) {
                    iterator.remove();
                    continue;
                }
                if (value instanceof String) continue;
                entry.setValue((Object)value.toString());
            }
        }
        profileList.removeIf(UnmodifiableConfig::isEmpty);
    }

    private void saveProfiles(List<CommentedConfig> list) {
        if (list.isEmpty()) {
            list.add(this.createPlaceholderConfig());
        }
        this.profilesProperty.set(list);
        this.configuration.save();
    }

    private CommentedConfig createPlaceholderConfig() {
        CommentedConfig config = this.configSupplier.get();
        config.set("type", (Object)"none");
        return config;
    }

    private List<CommentedConfig> createDefaultProfileList() {
        ArrayList<CommentedConfig> list = new ArrayList<CommentedConfig>();
        list.add(this.createPlaceholderConfig());
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateProfileList(Object el) {
        if (!(el instanceof List)) return false;
        if (!((List)el).stream().allMatch(CommentedConfig.class::isInstance)) return false;
        return true;
    }
}

