/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.http.server;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.authentication.http.server.CodeHandler;
import technicianlp.reauth.authentication.http.server.PageWriter;
import technicianlp.reauth.authentication.http.server.ResourcesHandler;

public final class AuthenticationCodeServer {
    private final Consumer<Boolean> stopServer;
    private boolean running = true;

    public AuthenticationCodeServer(int port, String loginUrl, CompletableFuture<String> codeFuture, Executor executor) throws IOException, NoClassDefFoundError {
        InetSocketAddress localAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
        HttpServer server = HttpServer.create(localAddress, 0);
        server.setExecutor(executor);
        PageWriter writer = new PageWriter(loginUrl);
        server.createContext("/", new CodeHandler(writer, codeFuture));
        server.createContext("/res/", new ResourcesHandler(writer));
        codeFuture.whenCompleteAsync((v, exception) -> this.stop(exception != null), executor);
        ReAuth.log.info("Starting local endpoint");
        server.start();
        ReAuth.log.info("Started local endpoint");
        this.stopServer = immediate -> server.stop(immediate != false ? 0 : 1);
    }

    public final synchronized void stop(boolean immediate) {
        if (this.running) {
            this.running = false;
            if (!immediate) {
                ReAuth.log.info("About to stop local endpoint");
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException exception) {
                    ReAuth.log.warn("Interrupted while waiting to stop local endpoint", (Throwable)exception);
                }
            }
            ReAuth.log.info("Stopping local endpoint");
            this.stopServer.accept(immediate);
            ReAuth.log.info("Stopped local endpoint");
        }
    }
}

