/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.ReconnectHelper;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.gui.MainScreen;
import technicianlp.reauth.session.SessionChecker;
import technicianlp.reauth.session.SessionStatus;
import technicianlp.reauth.util.ReflectionUtils;

@Mod.EventBusSubscriber(modid="reauth", value={Dist.CLIENT})
public final class EventHandler {
    private static final Field disconnectMessage = ReflectionUtils.findObfuscatedField(DisconnectedScreen.class, "f_95988_", "reason");

    @SubscribeEvent
    public static void onInitGui(ScreenEvent.InitScreenEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof JoinMultiplayerScreen) {
            event.addListener((GuiEventListener)new Button(5, 5, 100, 20, (Component)new TranslatableComponent("reauth.gui.button"), b -> EventHandler.openAuthenticationScreen()));
        } else if (screen instanceof TitleScreen) {
            event.addListener((GuiEventListener)new Button(-50, -50, 20, 20, (Component)new TranslatableComponent("reauth.gui.button"), b -> EventHandler.openAuthenticationScreen()));
        } else if (screen instanceof DisconnectedScreen) {
            EventHandler.handleDisconnectScreen(event, screen);
        } else if (screen instanceof ConnectScreen) {
            ReconnectHelper.setConnectScreen((ConnectScreen)screen);
        }
    }

    private static void handleDisconnectScreen(ScreenEvent.InitScreenEvent.Post event, Screen screen) {
        if ("connect.failed".equals(ReconnectHelper.getTranslationKey(screen.m_96636_())) && ReconnectHelper.getTranslationKey(ReflectionUtils.getField(disconnectMessage, screen)).startsWith("disconnect.loginFailed")) {
            AbstractWidget menu = (AbstractWidget)event.getListenersList().get(0);
            Profile profile = ReAuth.profiles.getProfile();
            TranslatableComponent retryText = profile != null ? new TranslatableComponent("reauth.retry", new Object[]{profile.getValue("name", "Steve")}) : new TranslatableComponent("reauth.retry.disabled");
            Button retryButton = new Button(menu.f_93620_, menu.f_93621_ + 25, 200, 20, (Component)retryText, b -> ReconnectHelper.retryLogin(profile));
            if (profile == null || !ReconnectHelper.hasConnectionInfo()) {
                retryButton.f_93623_ = false;
            }
            event.addListener((GuiEventListener)retryButton);
        }
    }

    private static void openAuthenticationScreen() {
        Minecraft.m_91087_().pushGuiLayer((Screen)new MainScreen());
    }

    @SubscribeEvent
    public static void onDrawGui(ScreenEvent.DrawScreenEvent.Post e) {
        if (e.getScreen() instanceof JoinMultiplayerScreen) {
            User user = Minecraft.m_91087_().m_91094_();
            SessionStatus state = SessionChecker.getSessionStatus(user.m_92547_(), user.m_92545_());
            Minecraft.m_91087_().f_91062_.m_92750_(e.getPoseStack(), I18n.m_118938_((String)state.getTranslationKey(), (Object[])new Object[0]), 110.0f, 10.0f, -1);
        }
    }

    @SubscribeEvent
    public static void onOpenGui(ScreenOpenEvent e) {
        if (e.getScreen() instanceof JoinMultiplayerScreen && Minecraft.m_91087_().f_91080_ instanceof JoinMultiplayerScreen && Screen.m_96638_()) {
            SessionChecker.invalidate();
        }
    }
}

