/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.config;

import com.lgmrszd.compressedcreativity.config.PressureTierConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_MACHINES = "machines";
    public static final String CATEGORY_ROTATIONAL_COMPRESSOR = "rotational_compressor";
    public static final String CATEGORY_AIR_BLOWER = "air_blower";
    public static final String CATEGORY_ENGINE = "compressed_air_engine";
    public static final String CATEGORY_CUSTOM_PRESSURE = "custom_pressure";
    public static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec.IntValue ROTATIONAL_COMPRESSOR_STRESS;
    public static final ForgeConfigSpec.IntValue ROTATIONAL_COMPRESSOR_VOLUME;
    public static final ForgeConfigSpec.EnumValue<PressureTierConfig.PressureTierEnum> ROTATIONAL_COMPRESSOR_PRESSURE_TIER;
    public static final ForgeConfigSpec.DoubleValue ROTATIONAL_COMPRESSOR_DANGER_PRESSURE;
    public static final ForgeConfigSpec.DoubleValue ROTATIONAL_COMPRESSOR_CRITICAL_PRESSURE;
    public static final ForgeConfigSpec.DoubleValue ROTATIONAL_COMPRESSOR_BASE_PRODUCTION;
    public static final ForgeConfigSpec.IntValue AIR_BLOWER_VOLUME;
    public static final ForgeConfigSpec.DoubleValue AIR_BLOWER_WORK_PRESSURE;
    public static final ForgeConfigSpec.DoubleValue AIR_BLOWER_OVERWORK_PRESSURE;
    public static final ForgeConfigSpec.EnumValue<PressureTierConfig.PressureTierEnum> AIR_BLOWER_PRESSURE_TIER;
    public static final ForgeConfigSpec.DoubleValue AIR_BLOWER_DANGER_PRESSURE;
    public static final ForgeConfigSpec.DoubleValue AIR_BLOWER_CRITICAL_PRESSURE;
    public static final ForgeConfigSpec.DoubleValue AIR_BLOWER_AIR_USAGE_PER_BAR;
    public static final ForgeConfigSpec.IntValue COMPRESSED_AIR_ENGINE_VOLUME;
    public static final ForgeConfigSpec.IntValue COMPRESSED_AIR_ENGINE_STRESS;
    public static final ForgeConfigSpec.DoubleValue COMPRESSED_AIR_ENGINE_WORK_PRESSURE;
    public static final ForgeConfigSpec.EnumValue<PressureTierConfig.PressureTierEnum> COMPRESSED_AIR_ENGINE_PRESSURE_TIER;
    public static final ForgeConfigSpec.DoubleValue COMPRESSED_AIR_ENGINE_DANGER_PRESSURE;
    public static final ForgeConfigSpec.DoubleValue COMPRESSED_AIR_ENGINE_CRITICAL_PRESSURE;
    public static final ForgeConfigSpec.DoubleValue COMPRESSED_AIR_ENGINE_AIR_USAGE_IDLE;
    public static final ForgeConfigSpec.DoubleValue COMPRESSED_AIR_ENGINE_AIR_USAGE_WORK;

    private static ForgeConfigSpec.IntValue makeVolumeField(int def) {
        return COMMON_BUILDER.comment("Air Volume of the machine\nDefault value: " + def).defineInRange("volume", def, 0, Integer.MAX_VALUE);
    }

    private static ForgeConfigSpec.DoubleValue makeDangerPressureField(double def) {
        return COMMON_BUILDER.comment("Danger Pressure of the machine\nDefault value: " + def).defineInRange("danger_pressure", def, 0.0, 20.0);
    }

    private static ForgeConfigSpec.DoubleValue makeCriticalPressureField(double def) {
        return COMMON_BUILDER.comment("Additional Critical Pressure of the machine.\nActual Critical Pressure is the sum of this value and Danger Pressure\nDefault value: " + def).defineInRange("critical_pressure", def, 0.0, 20.0);
    }

    private static ForgeConfigSpec.EnumValue<PressureTierConfig.PressureTierEnum> makePressureTierFieldAndPushCategory() {
        ForgeConfigSpec.EnumValue pressure_tier = COMMON_BUILDER.comment("Pressure Tier of the machine\nAll but CUSTOM one match Pressure Tiers from PNC:R").defineEnum("pressure_tier", (Enum)PressureTierConfig.PressureTierEnum.TIER_ONE);
        COMMON_BUILDER.comment("Values from Custom Air Pressure for this machine").push(CATEGORY_CUSTOM_PRESSURE);
        return pressure_tier;
    }

    static {
        COMMON_BUILDER.comment("General Configuration").push(CATEGORY_GENERAL);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Machines Configuration").push(CATEGORY_MACHINES);
        COMMON_BUILDER.comment("Rotational Compressor").push(CATEGORY_ROTATIONAL_COMPRESSOR);
        ROTATIONAL_COMPRESSOR_STRESS = COMMON_BUILDER.comment("Max Stress Impact of the machine (at 256 rpm)\nDefault value: 2048").defineInRange("stress", 2048, 0, Integer.MAX_VALUE);
        ROTATIONAL_COMPRESSOR_VOLUME = CommonConfig.makeVolumeField(5000);
        ROTATIONAL_COMPRESSOR_BASE_PRODUCTION = COMMON_BUILDER.comment("How much air this machine produces per tick if it is running at 128 rpm\nDefault value: 10.0").defineInRange("base_production", 10.0, 0.0, 999999.0);
        ROTATIONAL_COMPRESSOR_PRESSURE_TIER = CommonConfig.makePressureTierFieldAndPushCategory();
        ROTATIONAL_COMPRESSOR_DANGER_PRESSURE = CommonConfig.makeDangerPressureField(5.0);
        ROTATIONAL_COMPRESSOR_CRITICAL_PRESSURE = CommonConfig.makeCriticalPressureField(2.0);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Air Blower").push(CATEGORY_AIR_BLOWER);
        AIR_BLOWER_VOLUME = CommonConfig.makeVolumeField(500);
        AIR_BLOWER_WORK_PRESSURE = COMMON_BUILDER.comment("Pressure required by machine to operate\nDefault value: 0.5").defineInRange("work_pressure", 0.5, 0.0, 20.0);
        AIR_BLOWER_OVERWORK_PRESSURE = COMMON_BUILDER.comment("Pressure required for double processing speed\nDefault value: 4.8").defineInRange("overwork_pressure", 4.8, 0.0, 20.0);
        AIR_BLOWER_AIR_USAGE_PER_BAR = COMMON_BUILDER.comment("Air Usage per Bar (total air usage = this value * current pressure)").defineInRange("air_usage_per_bar", 4.0, 0.0, 999999.0);
        AIR_BLOWER_PRESSURE_TIER = CommonConfig.makePressureTierFieldAndPushCategory();
        AIR_BLOWER_DANGER_PRESSURE = CommonConfig.makeDangerPressureField(5.0);
        AIR_BLOWER_CRITICAL_PRESSURE = CommonConfig.makeCriticalPressureField(2.0);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Compressed Air Engine").push(CATEGORY_ENGINE);
        COMPRESSED_AIR_ENGINE_STRESS = COMMON_BUILDER.comment("Max/Worl Stress Capacity of the machine (at 256 rpm)\nDefault value: 1024").defineInRange("stress", 1024, 0, Integer.MAX_VALUE);
        COMPRESSED_AIR_ENGINE_VOLUME = CommonConfig.makeVolumeField(1000);
        COMPRESSED_AIR_ENGINE_AIR_USAGE_WORK = COMMON_BUILDER.comment("Air usage when working\nDefault value: 20.0").defineInRange("air_usage_work", 40.0, 0.0, 999999.0);
        COMPRESSED_AIR_ENGINE_AIR_USAGE_IDLE = COMMON_BUILDER.comment("Air usage when idle\nDefault value: 40.0").defineInRange("air_usage_idle", 80.0, 0.0, 999999.0);
        COMPRESSED_AIR_ENGINE_WORK_PRESSURE = COMMON_BUILDER.comment("Pressure required to operate\nDefault value: 3.0").defineInRange("work_pressure", 3.0, 0.0, 20.0);
        COMPRESSED_AIR_ENGINE_PRESSURE_TIER = CommonConfig.makePressureTierFieldAndPushCategory();
        COMPRESSED_AIR_ENGINE_DANGER_PRESSURE = CommonConfig.makeDangerPressureField(5.0);
        COMPRESSED_AIR_ENGINE_CRITICAL_PRESSURE = CommonConfig.makeCriticalPressureField(2.0);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
        COMMON_SPEC = COMMON_BUILDER.build();
    }
}

