/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.blocks.air_blower;

import com.lgmrszd.compressedcreativity.blocks.air_blower.AirBlowerTileEntity;
import com.lgmrszd.compressedcreativity.index.CCMisc;
import com.lgmrszd.compressedcreativity.index.CCShapes;
import com.lgmrszd.compressedcreativity.index.CCTileEntities;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ITE;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.misc.IMiscHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AirBlowerBlock
extends Block
implements IPneumaticWrenchable,
IWrenchable,
ITE<AirBlowerTileEntity> {
    public static final Property<Direction> FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty[] CONNECTION_PROPERTIES = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};

    public AirBlowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{UP}).m_61104_(new Property[]{DOWN}).m_61104_(new Property[]{NORTH}).m_61104_(new Property[]{SOUTH}).m_61104_(new Property[]{EAST}).m_61104_(new Property[]{WEST});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_7820_());
        }
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        BlockEntity te;
        super.onNeighborChange(state, world, pos, neighbor);
        BlockEntity blockEntity = te = state.m_155947_() ? world.m_7702_(pos) : null;
        if (te instanceof AirBlowerTileEntity) {
            AirBlowerTileEntity abte = (AirBlowerTileEntity)te;
            abte.updateAirHandler();
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing != stateIn.m_61143_(FACING)) {
            BlockEntity other_te = worldIn.m_7702_(currentPos.m_142300_(facing));
            boolean has_connection = other_te != null && other_te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, facing.m_122424_()).isPresent();
            stateIn = (BlockState)stateIn.m_61124_((Property)CONNECTION_PROPERTIES[facing.m_122411_()], (Comparable)Boolean.valueOf(has_connection));
        } else {
            stateIn = (BlockState)stateIn.m_61124_((Property)CONNECTION_PROPERTIES[facing.m_122411_()], (Comparable)Boolean.valueOf(false));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult result = super.onWrenched(state, context);
        if (result == InteractionResult.SUCCESS) {
            BlockEntity blockEntity;
            IMiscHelpers miscHelpers = PneumaticRegistry.getInstance().getMiscHelpers();
            miscHelpers.forceClientShapeRecalculation(context.m_43725_(), context.m_8083_());
            if (!context.m_43725_().m_5776_() && (blockEntity = context.m_43725_().m_7702_(context.m_8083_())) instanceof AirBlowerTileEntity) {
                AirBlowerTileEntity abte = (AirBlowerTileEntity)blockEntity;
                abte.updateAirHandler();
            }
        }
        return result;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te;
        if (state.m_60734_() != newState.m_60734_() && (te = world.m_7702_(pos)) instanceof AirBlowerTileEntity) {
            AirBlowerTileEntity abte = (AirBlowerTileEntity)te;
            IMiscHelpers miscHelpers = PneumaticRegistry.getInstance().getMiscHelpers();
            miscHelpers.playMachineBreakEffect((BlockEntity)abte);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CCShapes.AIR_BLOWER.get((Direction)state.m_61143_(FACING));
    }

    public Class<AirBlowerTileEntity> getTileEntityClass() {
        return AirBlowerTileEntity.class;
    }

    public BlockEntityType<? extends AirBlowerTileEntity> getTileEntityType() {
        return (BlockEntityType)CCTileEntities.AIR_BLOWER.get();
    }

    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction side, InteractionHand hand) {
        UseOnContext ctx = new UseOnContext(player, hand, new BlockHitResult(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123341_()), side, pos, false));
        return ctx.m_43723_() != null && (ctx.m_43723_().m_6047_() ? this.onSneakWrenched(world.m_8055_(pos), ctx) : this.onWrenched(world.m_8055_(pos), ctx)) == InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> infoList, TooltipFlag par4) {
        CCMisc.appendPneumaticHoverText(() -> this.m_142194_(BlockPos.f_121853_, this.m_49966_()), infoList);
    }
}

