/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity;

import com.lgmrszd.compressedcreativity.blocks.air_blower.AirBlowerTileEntity;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.instruction.EmitParticlesInstruction;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PonderScenes {
    private static final Logger logger = LogManager.getLogger((String)"compressedcreativity");

    private static void updatePressure(SceneBuilder scene, BlockPos air_blower) {
        scene.world.modifyTileEntity(air_blower, AirBlowerTileEntity.class, te -> te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(cap -> cap.setPressure(cap.getDangerPressure())));
    }

    public static void rotationalCompressor(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("rotational_compressor", "Generating Pressure using a Rotational Compressor");
        scene.configureBasePlate(0, 1, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        BlockPos compressor = util.grid.at(2, 1, 3);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 0, 2, 2, 2), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.position(2, 1, 3), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.position(1, 1, 3), Direction.DOWN);
        scene.idle(2);
        scene.world.showSection(util.select.position(1, 2, 3), Direction.DOWN);
        scene.idle(10);
        scene.overlay.showText(50).text("The Rotational Compressor is used to generate pressure").placeNearTarget().pointAt(util.vector.topOf(compressor));
        scene.idle(60);
        scene.addKeyframe();
        BlockPos leverPos = util.grid.at(2, 2, 1);
        Selection reverse = util.select.fromTo(2, 1, 1, 2, 1, 3);
        scene.world.toggleRedstonePower(util.select.fromTo(leverPos, leverPos.m_7495_()));
        scene.effects.indicateRedstone(leverPos);
        scene.world.modifyKineticSpeed(reverse, f -> Float.valueOf(-f.floatValue()));
        scene.overlay.showText(50).text("Specific Rotational Direction needed in order for Compressor to work.").placeNearTarget().pointAt(util.vector.topOf(compressor));
        scene.idle(5);
        Vec3 itemVec = util.vector.blockSurface(util.grid.at(1, 2, 3), Direction.UP);
        scene.effects.emitParticles(itemVec, EmitParticlesInstruction.Emitter.simple((ParticleOptions)AirParticleData.DENSE, (Vec3)new Vec3(0.0, 0.1, 0.0)), 1.0f, 120);
        scene.idle(60);
        scene.overlay.showText(50).text("Air will leak from unconnected sides of tubes or some machines!").placeNearTarget().pointAt(itemVec);
        scene.idle(60);
        scene.addKeyframe();
        scene.world.destroyBlock(util.grid.at(1, 2, 3));
        scene.world.destroyBlock(util.grid.at(1, 1, 3));
        scene.idle(20);
        scene.overlay.showText(50).text("Don't let pressure built up in the machines.").placeNearTarget().pointAt(util.vector.topOf(compressor));
        scene.idle(60);
        scene.overlay.showText(50).text("If the pressure builds up...").colored(PonderPalette.RED).placeNearTarget().pointAt(util.vector.topOf(compressor));
        scene.idle(60);
        scene.world.destroyBlock(compressor);
        scene.effects.emitParticles(util.vector.centerOf(compressor), EmitParticlesInstruction.Emitter.simple((ParticleOptions)ParticleTypes.f_123813_, (Vec3)Vec3.f_82478_), 2.0f, 1);
        scene.effects.emitParticles(util.vector.centerOf(compressor), EmitParticlesInstruction.Emitter.withinBlockSpace((ParticleOptions)AirParticleData.DENSE, (Vec3)Vec3.f_82478_), 40.0f, 10);
        scene.idle(10);
        scene.overlay.showText(50).text("Machine could explode!").colored(PonderPalette.RED).placeNearTarget().pointAt(util.vector.centerOf(compressor));
        scene.idle(60);
    }

    public static void airBlower(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("air_blower", "Air Flow from Air Pressure");
        scene.configureBasePlate(0, 1, 5);
        BlockPos air_blower = util.grid.at(1, 1, 4);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 0, 3, 1, 4).add(util.select.position(2, 1, 4)), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.position(air_blower), Direction.DOWN);
        scene.idle(40);
        scene.overlay.showText(80).text("Air Blower uses pressurized air to create Air Current").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(air_blower));
        PonderScenes.updatePressure(scene, air_blower);
        scene.idle(90);
        PonderScenes.updatePressure(scene, air_blower);
        scene.overlay.showText(160).text("Air Current speed, as well as air consumption rate, depends on current Air Pressure").placeNearTarget().pointAt(util.vector.topOf(air_blower));
        scene.idle(160);
        PonderScenes.updatePressure(scene, air_blower);
        scene.markAsFinished();
    }

    public static void CompressedAirEngine(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("compressed_air_engine", "Rotation from Pressure");
        BlockPos cae1 = util.grid.at(3, 1, 2);
        BlockPos cae2 = util.grid.at(1, 1, 1);
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0).substract(util.select.position(1, 0, 5)).substract(util.select.position(3, 0, 5)), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.position(cae1), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 2, 2, 3, 2, 5).add(util.select.fromTo(3, 0, 5, 3, 2, 5)), Direction.DOWN);
        scene.idle(20);
        scene.overlay.showText(80).text("Compressed Air Engine uses pressurized air to create rotational force").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(cae1));
        scene.idle(90);
        scene.world.showSection(util.select.fromTo(1, 1, 1, 1, 1, 3), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(1, 2, 3, 1, 2, 5).add(util.select.fromTo(1, 0, 5, 1, 2, 5)), Direction.DOWN);
        scene.idle(10);
        scene.overlay.showText(80).text("Multiple Engines can be combined together by placing one on another or attaching with wrench").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(cae2));
        scene.idle(90);
        scene.markAsFinished();
    }
}

