/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.items.CapsuleItem;
import capsule.recipes.CapsuleRecipes;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecoveryCapsuleRecipe
implements CraftingRecipe {
    public final ShapelessRecipe recipe;

    public RecoveryCapsuleRecipe(ShapelessRecipe recipe) {
        this.recipe = recipe;
    }

    public ItemStack m_8043_() {
        return this.recipe.m_8043_();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
            if (!(itemstack.m_41720_() instanceof CapsuleItem)) continue;
            nonnulllist.set(i, (Object)itemstack.m_41777_());
        }
        return nonnulllist;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return this.recipe.m_5818_(inv, worldIn);
    }

    public ItemStack assemble(CraftingContainer invC) {
        for (int i = 0; i < invC.m_6643_(); ++i) {
            ItemStack itemstack = invC.m_8020_(i);
            if (!CapsuleItem.isLinkedStateCapsule(itemstack)) continue;
            ItemStack copy = itemstack.m_41777_();
            CapsuleItem.setOneUse(copy);
            return copy;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return this.recipe.m_8004_(width, height);
    }

    public ResourceLocation m_6423_() {
        return this.recipe.m_6423_();
    }

    public RecipeSerializer<?> m_7707_() {
        return CapsuleRecipes.RECOVERY_CAPSULE_SERIALIZER;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<RecoveryCapsuleRecipe> {
        public RecoveryCapsuleRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new RecoveryCapsuleRecipe((ShapelessRecipe)ShapelessRecipe.Serializer.f_44077_.m_6729_(recipeId, json));
        }

        public RecoveryCapsuleRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new RecoveryCapsuleRecipe((ShapelessRecipe)ShapelessRecipe.Serializer.f_44077_.m_8005_(recipeId, buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer, RecoveryCapsuleRecipe recipe) {
            ShapelessRecipe.Serializer.f_44077_.m_6178_(buffer, (Recipe)recipe.recipe);
        }
    }
}

