/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.items.CapsuleItem;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class CapsuleIngredient
extends Ingredient {
    private final ItemStack referenceStack;

    protected CapsuleIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.ItemValue(stack)));
        this.referenceStack = stack;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null || !(input.m_41720_() instanceof CapsuleItem)) {
            return false;
        }
        return this.referenceStack.m_41720_() == input.m_41720_() && CapsuleItem.hasState(input, CapsuleItem.getState(this.referenceStack)) && CapsuleItem.isBlueprint(input) == CapsuleItem.isBlueprint(this.referenceStack);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.addProperty("item", this.referenceStack.m_41720_().getRegistryName().toString());
        json.addProperty("count", (Number)this.referenceStack.m_41613_());
        if (this.referenceStack.m_41782_()) {
            json.addProperty("nbt", this.referenceStack.m_41783_().toString());
        }
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<CapsuleIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public CapsuleIngredient parse(FriendlyByteBuf buffer) {
            return new CapsuleIngredient(buffer.m_130267_());
        }

        public CapsuleIngredient parse(JsonObject json) {
            return new CapsuleIngredient(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
        }

        public void write(FriendlyByteBuf buffer, CapsuleIngredient ingredient) {
            buffer.writeItemStack(ingredient.referenceStack, false);
        }
    }
}

