/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.helpers.Capsule;
import capsule.items.CapsuleItem;
import capsule.recipes.CapsuleRecipes;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BlueprintCapsuleRecipe
implements CraftingRecipe {
    public final ShapedRecipe recipe;

    public BlueprintCapsuleRecipe(ShapedRecipe recipe) {
        this.recipe = recipe;
    }

    public ItemStack m_8043_() {
        return this.recipe.m_8043_();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = this.recipe.m_7527_();
        return ingredients;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
            if (!(itemstack.m_41720_() instanceof CapsuleItem)) continue;
            nonnulllist.set(i, (Object)itemstack.m_41777_());
        }
        return nonnulllist;
    }

    private boolean IsCopyable(ItemStack itemstack) {
        return CapsuleItem.isLinkedStateCapsule(itemstack) || CapsuleItem.isBlueprint(itemstack) || CapsuleItem.isOneUse(itemstack);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        if (!this.recipe.m_5818_(inv, worldIn)) {
            return false;
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (!(itemstack.m_41720_() instanceof CapsuleItem) || this.IsCopyable(itemstack)) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack referenceCapsule = this.recipe.m_8043_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (!this.IsCopyable(itemstack)) continue;
            referenceCapsule = itemstack;
        }
        try {
            ItemStack blueprintItem = Capsule.newLinkedCapsuleItemStack(CapsuleItem.getStructureName(referenceCapsule), CapsuleItem.getBaseColor(this.recipe.m_8043_()), 0xFFFFFF, CapsuleItem.getSize(referenceCapsule), CapsuleItem.isOverpowered(referenceCapsule), referenceCapsule.m_41783_() != null ? referenceCapsule.m_41783_().m_128461_("label") : null, 0);
            CapsuleItem.setBlueprint(blueprintItem);
            if (blueprintItem.m_41783_() != null) {
                blueprintItem.m_41783_().m_128379_("templateShouldBeCopied", true);
            }
            CapsuleItem.setState(blueprintItem, CapsuleItem.CapsuleState.DEPLOYED);
            return blueprintItem;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ItemStack.f_41583_;
        }
    }

    public boolean m_8004_(int width, int height) {
        return this.recipe.m_8004_(width, height);
    }

    public ResourceLocation m_6423_() {
        return this.recipe.m_6423_();
    }

    public RecipeSerializer<?> m_7707_() {
        return CapsuleRecipes.BLUEPRINT_CAPSULE_SERIALIZER;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<BlueprintCapsuleRecipe> {
        public BlueprintCapsuleRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new BlueprintCapsuleRecipe((ShapedRecipe)ShapedRecipe.Serializer.f_44076_.m_6729_(recipeId, json));
        }

        public BlueprintCapsuleRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new BlueprintCapsuleRecipe((ShapedRecipe)ShapedRecipe.Serializer.f_44076_.m_8005_(recipeId, buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer, BlueprintCapsuleRecipe recipe) {
            ShapedRecipe.Serializer.f_44076_.m_6178_(buffer, (Recipe)recipe.recipe);
        }
    }
}

