/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.items.CapsuleItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LabelEditedMessageToServer {
    protected static final Logger LOGGER = LogManager.getLogger(LabelEditedMessageToServer.class);
    private String label;

    public LabelEditedMessageToServer(String newLabel) {
        this.setLabel(newLabel);
    }

    public LabelEditedMessageToServer(FriendlyByteBuf buf) {
        try {
            this.setLabel(buf.m_130136_(Short.MAX_VALUE));
        }
        catch (IndexOutOfBoundsException ioe) {
            LOGGER.error("Exception while reading CapsuleLabelEditedMessageToClient: " + ioe);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.label);
    }

    public void onServer(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            LOGGER.error("ServerPlayerEntity was null when LabelEditedMessageToServer was received");
            return;
        }
        ctx.get().enqueueWork(() -> {
            ItemStack serverStack = sendingPlayer.m_21205_();
            if (serverStack.m_41720_() instanceof CapsuleItem) {
                CapsuleItem.setLabel(serverStack, this.getLabel());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public String toString() {
        return this.getClass().toString() + "[label=" + this.getLabel() + "]";
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

