/*
 * Decompiled with CFR 0.152.
 */
package capsule.enchantments;

import capsule.Config;
import capsule.enchantments.RecallEnchant;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleEnchantments {
    private static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"capsule");
    public static final RegistryObject<Enchantment> RECALL = ENCHANTMENTS.register("recall", CapsuleEnchantments::CreateRecall);
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleEnchantments.class);
    public static final Predicate<Entity> hasRecallEnchant = entityIn -> entityIn instanceof ItemEntity && EnchantmentHelper.m_44843_((Enchantment)((Enchantment)RECALL.get()), (ItemStack)((ItemEntity)entityIn).m_32055_()) > 0;

    public static void registerEnchantments(IEventBus eventBus) {
        ENCHANTMENTS.register(eventBus);
    }

    public static RecallEnchant CreateRecall() {
        Enchantment.Rarity enchantRarity = Enchantment.Rarity.RARE;
        try {
            enchantRarity = Enchantment.Rarity.valueOf((String)((String)Config.enchantRarity.get()));
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't find the rarity " + (String)Config.enchantRarity.get() + ". Using RARE instead.");
        }
        EnchantmentCategory recallEnchantTypeEnumValue = null;
        try {
            recallEnchantTypeEnumValue = EnchantmentCategory.valueOf((String)((String)Config.recallEnchantType.get()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new RecallEnchant(enchantRarity, recallEnchantTypeEnumValue);
    }
}

