/*
 * Decompiled with CFR 0.152.
 */
package capsule.client.render.vbo;

import capsule.client.render.vbo.CustomBufferBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;

public class CustomVertexBuffer
implements AutoCloseable {
    private int glBufferId;
    private final VertexFormat vertexFormat;
    private int count;

    public CustomVertexBuffer(VertexFormat vertexFormatIn) {
        this.vertexFormat = vertexFormatIn;
        RenderSystem.m_69531_(p_227876_1_ -> {
            this.glBufferId = p_227876_1_;
        });
    }

    public void bindBuffer() {
        RenderSystem.m_157208_((int)34962, () -> this.glBufferId);
    }

    public void upload(CustomBufferBuilder bufferIn) {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> this.uploadRaw(bufferIn));
        } else {
            this.uploadRaw(bufferIn);
        }
    }

    public CompletableFuture<Void> uploadLater(CustomBufferBuilder bufferIn) {
        if (!RenderSystem.m_69586_()) {
            return CompletableFuture.runAsync(() -> this.uploadRaw(bufferIn), p_227877_0_ -> RenderSystem.m_69879_(p_227877_0_::run));
        }
        this.uploadRaw(bufferIn);
        return CompletableFuture.completedFuture(null);
    }

    private void uploadRaw(CustomBufferBuilder bufferIn) {
        Pair<CustomBufferBuilder.DrawState, ByteBuffer> pair = bufferIn.getNextBuffer();
        if (this.glBufferId != -1) {
            ByteBuffer bytebuffer = (ByteBuffer)pair.getSecond();
            this.count = bytebuffer.remaining() / this.vertexFormat.m_86020_();
            this.bindBuffer();
            RenderSystem.m_69525_((int)34962, (ByteBuffer)bytebuffer, (int)35044);
            CustomVertexBuffer.unbindBuffer();
        }
    }

    public void draw(Matrix4f matrixIn, int modeIn) {
    }

    public static void unbindBuffer() {
        RenderSystem.m_157208_((int)34962, () -> 0);
    }

    @Override
    public void close() {
        if (this.glBufferId >= 0) {
            RenderSystem.m_69529_((int)this.glBufferId);
            this.glBufferId = -1;
        }
    }
}

