/*
 * Decompiled with CFR 0.152.
 */
package capsule.blocks;

import capsule.CapsuleMod;
import capsule.blocks.BlockCapsuleMarker;
import capsule.blocks.BlockCaptureCrasher;
import capsule.blocks.BlockDeployCrasher;
import capsule.blocks.BlockEntityCapture;
import capsule.blocks.CaptureBER;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.Type;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CapsuleBlocks {
    private static final ResourceLocation CAPSULE_MARKER_REGISTERY_NAME = new ResourceLocation("capsule", "capsulemarker");
    public static final ResourceLocation CAPSULE_MARKER_TE_REGISTERY_NAME = new ResourceLocation("capsule", "capsulemarker_te");
    public static BlockCapsuleMarker CAPSULE_MARKER;
    public static BlockEntityType<BlockEntityCapture> MARKER_TE;
    public static BlockCaptureCrasher blockCaptureCrasher;
    public static final String CAPTURE_CRASHER_REGISTERY_NAME = "capturecrasher";
    public static BlockDeployCrasher blockDeployCrasher;
    public static final String DEPLOY_CRASHER_REGISTERY_NAME = "deploycrasher";

    private static <T extends BlockEntity> BlockEntityType<T> buildBlockEntity(BlockEntityType.BlockEntitySupplier<T> supplier, ResourceLocation name, Block ... blocks) {
        Type type = Util.m_137456_((DSL.TypeReference)References.f_16781_, (String)name.toString());
        BlockEntityType te = BlockEntityType.Builder.m_155273_(supplier, (Block[])blocks).m_58966_(type);
        te.setRegistryName(name);
        return te;
    }

    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        CAPSULE_MARKER = new BlockCapsuleMarker();
        CAPSULE_MARKER.setRegistryName(CAPSULE_MARKER_REGISTERY_NAME);
        event.getRegistry().register((IForgeRegistryEntry)CAPSULE_MARKER);
        Map<String, String> env = System.getenv();
        if ("DEV".equals(env.get("__ENV__"))) {
            blockCaptureCrasher = new BlockCaptureCrasher();
            blockCaptureCrasher.setRegistryName(CAPTURE_CRASHER_REGISTERY_NAME);
            event.getRegistry().register((IForgeRegistryEntry)blockCaptureCrasher);
            blockDeployCrasher = new BlockDeployCrasher();
            blockDeployCrasher.setRegistryName(DEPLOY_CRASHER_REGISTERY_NAME);
            event.getRegistry().register((IForgeRegistryEntry)blockDeployCrasher);
        }
    }

    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        BlockItem markerItem = new BlockItem((Block)CAPSULE_MARKER, new Item.Properties().m_41491_(CapsuleMod.tabCapsule));
        markerItem.setRegistryName(CAPSULE_MARKER_REGISTERY_NAME);
        event.getRegistry().register((IForgeRegistryEntry)markerItem);
        Map<String, String> env = System.getenv();
        if ("DEV".equals(env.get("__ENV__"))) {
            event.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)blockCaptureCrasher, new Item.Properties().m_41491_(CapsuleMod.tabCapsule)).setRegistryName(blockCaptureCrasher.getRegistryName())));
            event.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)blockDeployCrasher, new Item.Properties().m_41491_(CapsuleMod.tabCapsule)).setRegistryName(blockDeployCrasher.getRegistryName())));
        }
    }

    public static void registerBlockEntities(RegistryEvent.Register<BlockEntityType<?>> event) {
        MARKER_TE = CapsuleBlocks.buildBlockEntity(BlockEntityCapture::new, CAPSULE_MARKER_TE_REGISTERY_NAME, new Block[]{CAPSULE_MARKER});
        event.getRegistry().register(MARKER_TE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerBlockEntitiesRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(MARKER_TE, CaptureBER::new);
    }
}

