/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.supermartijn642.simplemagnets.DemagnetizationCoilTile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemSpawnHandler {
    private static final ItemSpawnHandler SERVER = new ItemSpawnHandler();
    private static final ItemSpawnHandler CLIENT = new ItemSpawnHandler();
    private final HashMap<ResourceKey<Level>, List<WeakReference<DemagnetizationCoilTile>>> tiles = new HashMap();

    private static ItemSpawnHandler getInstance(Level world) {
        return world.f_46443_ ? CLIENT : SERVER;
    }

    public static void add(DemagnetizationCoilTile tile) {
        if (tile == null || tile.m_58901_() || !tile.m_58898_()) {
            return;
        }
        ItemSpawnHandler handler = ItemSpawnHandler.getInstance(tile.m_58904_());
        handler.tiles.putIfAbsent((ResourceKey<Level>)tile.m_58904_().m_46472_(), new LinkedList());
        handler.tiles.get(tile.m_58904_().m_46472_()).add(new WeakReference<DemagnetizationCoilTile>(tile));
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinWorldEvent e) {
        if (!(e.getEntity() instanceof ItemEntity)) {
            return;
        }
        ItemEntity item = (ItemEntity)e.getEntity();
        ItemSpawnHandler handler = ItemSpawnHandler.getInstance(e.getWorld());
        handler.tiles.putIfAbsent((ResourceKey<Level>)e.getWorld().m_46472_(), new LinkedList());
        ArrayList<WeakReference<DemagnetizationCoilTile>> toRemove = new ArrayList<WeakReference<DemagnetizationCoilTile>>();
        List<WeakReference<DemagnetizationCoilTile>> list = handler.tiles.get(e.getWorld().m_46472_());
        for (WeakReference<DemagnetizationCoilTile> reference : list) {
            DemagnetizationCoilTile tile = (DemagnetizationCoilTile)((Object)reference.get());
            if (tile == null || tile.m_58901_() || !tile.m_58898_()) {
                toRemove.add(reference);
                continue;
            }
            if (!tile.getArea().m_82390_(item.m_20182_()) || !tile.shouldEffectItem(item.m_32055_())) continue;
            item.getPersistentData().m_128379_("PreventRemoteMovement", true);
            item.getPersistentData().m_128379_("AllowMachineRemoteMovement", true);
        }
        list.removeAll(toRemove);
    }
}

