/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.util.StructureSearchWorker;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.text.WordUtils;

public class StructureUtils {
    public static ListMultimap<ResourceLocation, ResourceLocation> getStructureKeysToConfiguredStructureKeys(ServerLevel level) {
        ArrayListMultimap structureKeysToConfiguredStructureKeys = ArrayListMultimap.create();
        for (ConfiguredStructureFeature configuredStructure : StructureUtils.getConfiguredStructureRegistry(level)) {
            structureKeysToConfiguredStructureKeys.put((Object)StructureUtils.getKeyForStructure((Level)level, configuredStructure.f_65403_), (Object)StructureUtils.getKeyForConfiguredStructure(level, configuredStructure));
        }
        return structureKeysToConfiguredStructureKeys;
    }

    public static Map<ResourceLocation, ResourceLocation> getConfiguredStructureKeysToStructureKeys(ServerLevel level) {
        HashMap<ResourceLocation, ResourceLocation> configuredStructureKeysToStructureKeys = new HashMap<ResourceLocation, ResourceLocation>();
        for (ConfiguredStructureFeature configuredStructure : StructureUtils.getConfiguredStructureRegistry(level)) {
            configuredStructureKeysToStructureKeys.put(StructureUtils.getKeyForConfiguredStructure(level, configuredStructure), StructureUtils.getKeyForStructure((Level)level, configuredStructure.f_65403_));
        }
        return configuredStructureKeysToStructureKeys;
    }

    public static Registry<ConfiguredStructureFeature<?, ?>> getConfiguredStructureRegistry(ServerLevel level) {
        return level.m_5962_().m_206191_(Registry.f_122882_);
    }

    public static ResourceLocation getKeyForConfiguredStructure(ServerLevel level, ConfiguredStructureFeature<?, ?> structure) {
        return StructureUtils.getConfiguredStructureRegistry(level).m_7981_(structure);
    }

    public static ConfiguredStructureFeature<?, ?> getConfiguredStructureForKey(ServerLevel level, ResourceLocation key) {
        return (ConfiguredStructureFeature)StructureUtils.getConfiguredStructureRegistry(level).m_7745_(key);
    }

    public static ResourceLocation getKeyForStructure(Level level, StructureFeature<?> structure) {
        return structure.getRegistryName();
    }

    public static List<ResourceLocation> getAllowedConfiguredStructureKeys(ServerLevel level) {
        ArrayList<ResourceLocation> structures = new ArrayList<ResourceLocation>();
        for (ConfiguredStructureFeature structure : StructureUtils.getConfiguredStructureRegistry(level)) {
            if (structure == null || StructureUtils.getKeyForConfiguredStructure(level, structure) == null || StructureUtils.configuredStructureIsBlacklisted(level, structure)) continue;
            structures.add(StructureUtils.getKeyForConfiguredStructure(level, structure));
        }
        return structures;
    }

    public static boolean configuredStructureIsBlacklisted(ServerLevel level, ConfiguredStructureFeature<?, ?> structure) {
        List structureBlacklist = (List)ConfigHandler.GENERAL.structureBlacklist.get();
        for (String structureKey : structureBlacklist) {
            if (!StructureUtils.getKeyForConfiguredStructure(level, structure).toString().matches(StructureUtils.convertToRegex(structureKey))) continue;
            return true;
        }
        return false;
    }

    public static void searchForStructure(ServerLevel serverLevel, Player player, ItemStack stack, List<ConfiguredStructureFeature<?, ?>> configuredStructures, BlockPos startPos) {
        StructureSearchWorker worker = new StructureSearchWorker(serverLevel, player, stack, configuredStructures, startPos);
        worker.start();
    }

    public static List<ResourceLocation> getGeneratingDimensionKeys(ServerLevel serverLevel, ConfiguredStructureFeature<?, ?> structure) {
        ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
        for (ServerLevel level : serverLevel.m_142572_().m_129785_()) {
            ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
            Set biomeSet = chunkGenerator.m_62218_().m_207840_();
            if (structure.m_209752_().m_203614_().noneMatch(biomeSet::contains)) continue;
            dimensions.add(level.m_46472_().m_135782_());
        }
        if (structure.f_65403_ == StructureFeature.f_67022_ && dimensions.isEmpty()) {
            dimensions.add(new ResourceLocation("minecraft:overworld"));
        }
        return dimensions;
    }

    public static ListMultimap<ResourceLocation, ResourceLocation> getGeneratingDimensionsForAllowedConfiguredStructures(ServerLevel serverLevel) {
        ArrayListMultimap dimensionsForAllowedConfiguredStructures = ArrayListMultimap.create();
        for (ResourceLocation structureKey : StructureUtils.getAllowedConfiguredStructureKeys(serverLevel)) {
            ConfiguredStructureFeature<?, ?> structure = StructureUtils.getConfiguredStructureForKey(serverLevel, structureKey);
            dimensionsForAllowedConfiguredStructures.putAll((Object)structureKey, StructureUtils.getGeneratingDimensionKeys(serverLevel, structure));
        }
        return dimensionsForAllowedConfiguredStructures;
    }

    public static int getHorizontalDistanceToLocation(Player player, int x, int z) {
        return StructureUtils.getHorizontalDistanceToLocation(player.m_142538_(), x, z);
    }

    public static int getHorizontalDistanceToLocation(BlockPos startPos, int x, int z) {
        return (int)Mth.m_14116_((float)((float)startPos.m_123331_((Vec3i)new BlockPos(x, startPos.m_123342_(), z))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getPrettyStructureName(ResourceLocation key) {
        String name = key.toString();
        if (((Boolean)ConfigHandler.CLIENT.translateStructureNames.get()).booleanValue()) {
            name = I18n.m_118938_((String)Util.m_137492_((String)"structure", (ResourceLocation)key), (Object[])new Object[0]);
        }
        if (name.equals(Util.m_137492_((String)"structure", (ResourceLocation)key)) || !((Boolean)ConfigHandler.CLIENT.translateStructureNames.get()).booleanValue()) {
            name = key.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getPrettyStructureSource(ResourceLocation key) {
        if (key == null) {
            return "";
        }
        String registryEntry = key.toString();
        String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = ModList.get().getModContainerById(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getModInfo().getDisplayName();
        }
        return modid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String dimensionKeysToString(List<ResourceLocation> dimensions) {
        HashSet dimensionNames = new HashSet();
        dimensions.forEach(key -> dimensionNames.add(StructureUtils.getDimensionName(key)));
        return String.join((CharSequence)", ", dimensionNames);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String getDimensionName(ResourceLocation dimensionKey) {
        String name = I18n.m_118938_((String)Util.m_137492_((String)"dimension", (ResourceLocation)dimensionKey), (Object[])new Object[0]);
        if (name.equals(Util.m_137492_((String)"dimension", (ResourceLocation)dimensionKey))) {
            name = dimensionKey.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    private static String convertToRegex(String glob) {
        Object regex = "^";
        for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            regex = c == '*' ? (String)regex + ".*" : (c == '?' ? (String)regex + "." : (c == '.' ? (String)regex + "\\." : (String)regex + c));
        }
        regex = (String)regex + "$";
        return regex;
    }
}

