/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.common.WorldWorkerManager;

public class StructureSearchWorker
implements WorldWorkerManager.IWorker {
    public ServerLevel level;
    public List<ConfiguredStructureFeature<?, ?>> configuredStructures;
    public ResourceLocation structureKey;
    public BlockPos startPos;
    public int samples;
    public int nextLength;
    public Direction direction;
    public ItemStack stack;
    public Player player;
    public int chunkX;
    public int chunkZ;
    public int length;
    public boolean finished;
    public int x;
    public int z;
    public int lastRadiusThreshold;

    public StructureSearchWorker(ServerLevel world, Player player, ItemStack stack, List<ConfiguredStructureFeature<?, ?>> configuredStructures, BlockPos startPos) {
        this.level = world;
        this.player = player;
        this.stack = stack;
        this.configuredStructures = configuredStructures;
        this.startPos = startPos;
        this.chunkX = startPos.m_123341_() >> 4;
        this.chunkZ = startPos.m_123343_() >> 4;
        this.x = startPos.m_123341_();
        this.z = startPos.m_123343_();
        this.nextLength = 1;
        this.length = 0;
        this.samples = 0;
        this.direction = Direction.UP;
        this.lastRadiusThreshold = 0;
        this.finished = !world.m_142572_().m_129910_().m_5961_().m_64657_();
    }

    public void start() {
        if (!this.stack.m_41619_() && this.stack.m_41720_() == ExplorersCompass.explorersCompass) {
            if ((Integer)ConfigHandler.GENERAL.maxRadius.get() > 0) {
                ExplorersCompass.LOGGER.info("Starting search: " + ConfigHandler.GENERAL.maxRadius.get() + " max radius, " + ConfigHandler.GENERAL.maxSamples.get() + " max samples");
                WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)this);
            } else {
                this.finish(null);
            }
        }
    }

    public boolean hasWork() {
        return !this.finished && this.getRadius() < (Integer)ConfigHandler.GENERAL.maxRadius.get() && this.samples < (Integer)ConfigHandler.GENERAL.maxSamples.get();
    }

    public boolean doWork() {
        if (this.hasWork()) {
            int radius;
            if (this.direction == Direction.NORTH) {
                --this.chunkZ;
            } else if (this.direction == Direction.EAST) {
                ++this.chunkX;
            } else if (this.direction == Direction.SOUTH) {
                ++this.chunkZ;
            } else if (this.direction == Direction.WEST) {
                --this.chunkX;
            }
            this.x = this.chunkX << 4;
            this.z = this.chunkZ << 4;
            for (ConfiguredStructureFeature<?, ?> configuredStructure : this.configuredStructures) {
                StructureCheckResult checkResult = this.level.m_8595_().m_207777_(new ChunkPos(this.chunkX, this.chunkZ), configuredStructure, false);
                if (checkResult == StructureCheckResult.START_NOT_PRESENT) continue;
                if (checkResult == StructureCheckResult.START_PRESENT) {
                    this.finish(configuredStructure);
                    return true;
                }
                ChunkAccess chunkAccess = this.level.m_46819_(this.chunkX, this.chunkZ, ChunkStatus.f_62315_);
                StructureStart structureStart = this.level.m_8595_().m_207802_(SectionPos.m_175562_((ChunkAccess)chunkAccess), configuredStructure, (FeatureAccess)chunkAccess);
                if (structureStart == null || !structureStart.m_73603_()) continue;
                this.x = this.getLocatePos(structureStart.m_163625_()).m_123341_();
                this.z = this.getLocatePos(structureStart.m_163625_()).m_123343_();
                this.finish(configuredStructure);
                return true;
            }
            ++this.samples;
            ++this.length;
            if (this.length >= this.nextLength) {
                if (this.direction != Direction.UP) {
                    ++this.nextLength;
                    this.direction = this.direction.m_122427_();
                } else {
                    this.direction = Direction.NORTH;
                }
                this.length = 0;
            }
            if ((radius = this.getRadius()) > 250 && radius / 250 > this.lastRadiusThreshold) {
                if (!this.stack.m_41619_() && this.stack.m_41720_() == ExplorersCompass.explorersCompass) {
                    ((ExplorersCompassItem)this.stack.m_41720_()).setSearchRadius(this.stack, this.roundRadius(radius, 250), this.player);
                }
                this.lastRadiusThreshold = radius / 250;
            }
        }
        if (this.hasWork()) {
            return true;
        }
        this.finish(null);
        return false;
    }

    private void finish(ConfiguredStructureFeature<?, ?> configuredStructure) {
        if (!this.stack.m_41619_() && this.stack.m_41720_() == ExplorersCompass.explorersCompass) {
            if (configuredStructure != null) {
                ExplorersCompass.LOGGER.info("Search succeeded: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((ExplorersCompassItem)this.stack.m_41720_()).setFound(this.stack, StructureUtils.getKeyForConfiguredStructure(this.level, configuredStructure), this.x, this.z, this.samples, this.player);
                ((ExplorersCompassItem)this.stack.m_41720_()).setDisplayCoordinates(this.stack, (Boolean)ConfigHandler.GENERAL.displayCoordinates.get());
            } else {
                ExplorersCompass.LOGGER.info("Search failed: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((ExplorersCompassItem)this.stack.m_41720_()).setNotFound(this.stack, this.player, this.roundRadius(this.getRadius(), 250), this.samples);
            }
        } else {
            ExplorersCompass.LOGGER.error("Invalid compass after search");
        }
        this.finished = true;
    }

    private int getRadius() {
        return StructureUtils.getHorizontalDistanceToLocation(this.startPos, this.x, this.z);
    }

    private int roundRadius(int radius, int roundTo) {
        return radius / roundTo * roundTo;
    }

    private BlockPos getLocatePos(ChunkPos p_191115_) {
        return new BlockPos(p_191115_.m_45604_(), 0, p_191115_.m_45605_());
    }
}

