/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class SyncPacket {
    private boolean canTeleport;
    private List<ResourceLocation> allowedConfiguredStructureKeys;
    private ListMultimap<ResourceLocation, ResourceLocation> dimensionKeysForAllowedConfiguredStructureKeys;
    private Map<ResourceLocation, ResourceLocation> configuredStructureKeysToStructureKeys;
    private ListMultimap<ResourceLocation, ResourceLocation> structureKeysToConfiguredStructureKeys;

    public SyncPacket() {
    }

    public SyncPacket(boolean canTeleport, List<ResourceLocation> allowedStructures, ListMultimap<ResourceLocation, ResourceLocation> dimensionsForAllowedConfiguredStructures, Map<ResourceLocation, ResourceLocation> configuredStructureKeysToStructureKeys, ListMultimap<ResourceLocation, ResourceLocation> structureKeysToConfiguredStructureKeys) {
        this.canTeleport = canTeleport;
        this.allowedConfiguredStructureKeys = allowedStructures;
        this.dimensionKeysForAllowedConfiguredStructureKeys = dimensionsForAllowedConfiguredStructures;
        this.configuredStructureKeysToStructureKeys = configuredStructureKeysToStructureKeys;
        this.structureKeysToConfiguredStructureKeys = structureKeysToConfiguredStructureKeys;
    }

    public SyncPacket(FriendlyByteBuf buf) {
        this.canTeleport = buf.readBoolean();
        this.allowedConfiguredStructureKeys = new ArrayList<ResourceLocation>();
        this.dimensionKeysForAllowedConfiguredStructureKeys = ArrayListMultimap.create();
        this.configuredStructureKeysToStructureKeys = new HashMap<ResourceLocation, ResourceLocation>();
        this.structureKeysToConfiguredStructureKeys = ArrayListMultimap.create();
        int numConfiguredStructures = buf.readInt();
        for (int i = 0; i < numConfiguredStructures; ++i) {
            ResourceLocation configuredStructureKey = buf.m_130281_();
            int numDimensions = buf.readInt();
            ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
            for (int j = 0; j < numDimensions; ++j) {
                dimensions.add(buf.m_130281_());
            }
            ResourceLocation structureKey = buf.m_130281_();
            if (configuredStructureKey == null) continue;
            this.allowedConfiguredStructureKeys.add(configuredStructureKey);
            this.dimensionKeysForAllowedConfiguredStructureKeys.putAll((Object)configuredStructureKey, dimensions);
            this.configuredStructureKeysToStructureKeys.put(configuredStructureKey, structureKey);
        }
        int numStructures = buf.readInt();
        for (int i = 0; i < numStructures; ++i) {
            ResourceLocation structureKey = buf.m_130281_();
            int numStructuresToAdd = buf.readInt();
            for (int j = 0; j < numStructuresToAdd; ++j) {
                ResourceLocation configuredStructureKey = buf.m_130281_();
                this.structureKeysToConfiguredStructureKeys.put((Object)structureKey, (Object)configuredStructureKey);
            }
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedConfiguredStructureKeys.size());
        for (ResourceLocation configuredStructureKey : this.allowedConfiguredStructureKeys) {
            buf.m_130085_(configuredStructureKey);
            List dimensions = this.dimensionKeysForAllowedConfiguredStructureKeys.get((Object)configuredStructureKey);
            buf.writeInt(dimensions.size());
            for (ResourceLocation dimensionKey : dimensions) {
                buf.m_130085_(dimensionKey);
            }
            ResourceLocation structureKey = this.configuredStructureKeysToStructureKeys.get(configuredStructureKey);
            buf.m_130085_(structureKey);
        }
        buf.writeInt(this.structureKeysToConfiguredStructureKeys.keySet().size());
        for (ResourceLocation structureKey : this.structureKeysToConfiguredStructureKeys.keySet()) {
            buf.m_130085_(structureKey);
            List configuredStructureKeys = this.structureKeysToConfiguredStructureKeys.get((Object)structureKey);
            buf.writeInt(configuredStructureKeys.size());
            for (ResourceLocation configuredStructureKey : configuredStructureKeys) {
                buf.m_130085_(configuredStructureKey);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ExplorersCompass.canTeleport = this.canTeleport;
            ExplorersCompass.allowedConfiguredStructureKeys = this.allowedConfiguredStructureKeys;
            ExplorersCompass.dimensionKeysForAllowedConfiguredStructureKeys = this.dimensionKeysForAllowedConfiguredStructureKeys;
            ExplorersCompass.configuredStructureKeysToStructureKeys = this.configuredStructureKeysToStructureKeys;
            ExplorersCompass.structureKeysToConfiguredStructureKeys = this.structureKeysToConfiguredStructureKeys;
        });
        ctx.get().setPacketHandled(true);
    }
}

