/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.items;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.gui.GuiWrapper;
import com.chaosthedude.explorerscompass.network.SyncPacket;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import com.chaosthedude.explorerscompass.util.PlayerUtils;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;

public class ExplorersCompassItem
extends Item {
    public static final String NAME = "explorerscompass";

    public ExplorersCompassItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40756_));
        this.setRegistryName(NAME);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!player.m_6047_()) {
            if (level.m_5776_()) {
                ItemStack stack = ItemUtils.getHeldItem(player, ExplorersCompass.explorersCompass);
                GuiWrapper.openGUI(level, player, stack);
            } else {
                ServerLevel serverLevel = (ServerLevel)level;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                boolean canTeleport = (Boolean)ConfigHandler.GENERAL.allowTeleport.get() != false && PlayerUtils.canTeleport(player.m_20194_(), player);
                List<ResourceLocation> allowedStructures = StructureUtils.getAllowedConfiguredStructureKeys(serverLevel);
                ListMultimap<ResourceLocation, ResourceLocation> dimensionsForAllowedConfiguredStructures = StructureUtils.getGeneratingDimensionsForAllowedConfiguredStructures(serverLevel);
                ExplorersCompass.network.sendTo((Object)new SyncPacket(canTeleport, allowedStructures, dimensionsForAllowedConfiguredStructures, StructureUtils.getConfiguredStructureKeysToStructureKeys(serverLevel), StructureUtils.getStructureKeysToConfiguredStructureKeys(serverLevel)), serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
            }
        } else {
            this.setState(player.m_21120_(hand), null, CompassState.INACTIVE, player);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (this.getState(oldStack) == this.getState(newStack)) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void searchForStructure(Level level, Player player, ResourceLocation categoryKey, List<ResourceLocation> structureKeys, BlockPos pos, ItemStack stack) {
        this.setSearching(stack, categoryKey, player);
        this.setSearchRadius(stack, 0, player);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ArrayList configuredStructures = new ArrayList();
            for (ResourceLocation key : structureKeys) {
                configuredStructures.add(StructureUtils.getConfiguredStructureForKey(serverLevel, key));
            }
            StructureUtils.searchForStructure(serverLevel, player, stack, configuredStructures, pos);
        }
    }

    public boolean isActive(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return this.getState(stack) != CompassState.INACTIVE;
        }
        return false;
    }

    public void setSearching(ItemStack stack, ResourceLocation structureKey, Player player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.m_41783_().m_128359_("StructureKey", structureKey.toString());
            stack.m_41783_().m_128405_("State", CompassState.SEARCHING.getID());
        }
    }

    public void setFound(ItemStack stack, ResourceLocation structureKey, int x, int z, int samples, Player player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.m_41783_().m_128405_("State", CompassState.FOUND.getID());
            stack.m_41783_().m_128359_("StructureKey", structureKey.toString());
            stack.m_41783_().m_128405_("FoundX", x);
            stack.m_41783_().m_128405_("FoundZ", z);
            stack.m_41783_().m_128405_("Samples", samples);
        }
    }

    public void setNotFound(ItemStack stack, Player player, int searchRadius, int samples) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.m_41783_().m_128405_("State", CompassState.NOT_FOUND.getID());
            stack.m_41783_().m_128405_("SearchRadius", searchRadius);
            stack.m_41783_().m_128405_("Samples", samples);
        }
    }

    public void setInactive(ItemStack stack, Player player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.m_41783_().m_128405_("State", CompassState.INACTIVE.getID());
        }
    }

    public void setState(ItemStack stack, BlockPos pos, CompassState state, Player player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.m_41783_().m_128405_("State", state.getID());
        }
    }

    public void setFoundStructureX(ItemStack stack, int x, Player player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.m_41783_().m_128405_("FoundX", x);
        }
    }

    public void setFoundStructureZ(ItemStack stack, int z, Player player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.m_41783_().m_128405_("FoundZ", z);
        }
    }

    public void setStructureKey(ItemStack stack, ResourceLocation structureKey, Player player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.m_41783_().m_128359_("StructureKey", structureKey.toString());
        }
    }

    public void setSearchRadius(ItemStack stack, int searchRadius, Player player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.m_41783_().m_128405_("SearchRadius", searchRadius);
        }
    }

    public void setSamples(ItemStack stack, int samples, Player player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.m_41783_().m_128405_("Samples", samples);
        }
    }

    public void setDisplayCoordinates(ItemStack stack, boolean displayPosition) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.m_41783_().m_128379_("DisplayCoordinates", displayPosition);
        }
    }

    public CompassState getState(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return CompassState.fromID(stack.m_41783_().m_128451_("State"));
        }
        return null;
    }

    public int getFoundStructureX(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.m_41783_().m_128451_("FoundX");
        }
        return 0;
    }

    public int getFoundStructureZ(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.m_41783_().m_128451_("FoundZ");
        }
        return 0;
    }

    public ResourceLocation getStructureKey(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return new ResourceLocation(stack.m_41783_().m_128461_("StructureKey"));
        }
        return new ResourceLocation("");
    }

    public int getSearchRadius(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.m_41783_().m_128451_("SearchRadius");
        }
        return -1;
    }

    public int getSamples(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.m_41783_().m_128451_("Samples");
        }
        return -1;
    }

    public int getDistanceToBiome(Player player, ItemStack stack) {
        return StructureUtils.getHorizontalDistanceToLocation(player, this.getFoundStructureX(stack), this.getFoundStructureZ(stack));
    }

    public boolean shouldDisplayCoordinates(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack) && stack.m_41783_().m_128441_("DisplayCoordinates")) {
            return stack.m_41783_().m_128471_("DisplayCoordinates");
        }
        return true;
    }
}

