/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.tavern;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import tictim.hearthstones.contents.ModItems;

public final class TavernType {
    private static final Byte2ObjectArrayMap<TavernType> types = new Byte2ObjectArrayMap();
    public static final TavernType NORMAL = new TavernType(0, "normal", new ResourceLocation("hearthstones", "textures/screen/tavern/normal.png"), () -> new ItemStack((ItemLike)ModItems.TAVERN.get()), (Component)new TextComponent("Normal").m_130940_(ChatFormatting.RED));
    public static final TavernType SHABBY = new TavernType(1, "shabby", new ResourceLocation("hearthstones", "textures/screen/tavern/shabby.png"), () -> new ItemStack((ItemLike)ModItems.SHABBY_TAVERN.get()), (Component)new TextComponent("Shabby").m_130940_(ChatFormatting.GRAY));
    public static final TavernType GLOBAL = new TavernType(2, "global", new ResourceLocation("hearthstones", "textures/screen/tavern/global.png"), () -> new ItemStack((ItemLike)ModItems.GLOBAL_TAVERN.get()), (Component)new TextComponent("Global").m_130940_(ChatFormatting.BLUE));
    public final byte id;
    public final String name;
    public final ResourceLocation tavernUITexture;
    private final Supplier<ItemStack> renderStackSupplier;
    public final Component commandAppearance;
    private ItemStack stackForRender;

    public static TavernType of(int id) {
        return TavernType.of((byte)id);
    }

    public static TavernType of(byte id) {
        TavernType type = (TavernType)types.get(id);
        return type == null ? NORMAL : type;
    }

    public TavernType(int id, String name, ResourceLocation tavernUITexture, Supplier<ItemStack> renderStackSupplier, Component commandAppearance) {
        byte bid = (byte)id;
        if (types.containsKey(bid)) {
            throw new IllegalStateException("TavernType with id " + id + " already exists.");
        }
        types.put(bid, (Object)this);
        this.id = bid;
        this.name = name;
        this.tavernUITexture = Objects.requireNonNull(tavernUITexture);
        this.renderStackSupplier = Objects.requireNonNull(renderStackSupplier);
        this.commandAppearance = commandAppearance;
    }

    public ItemStack stackForRender() {
        if (this.stackForRender == null) {
            this.stackForRender = this.renderStackSupplier.get();
        }
        return this.stackForRender;
    }

    public void resetRenderStack() {
        this.stackForRender = null;
    }

    public int hashCode() {
        return this.id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TavernType)) return false;
        TavernType t = (TavernType)obj;
        if (t.id != this.id) return false;
        return true;
    }

    public String toString() {
        return "TavernType{id=" + this.id + ", name='" + this.name + "'}";
    }
}

