/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.tavern;

import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import tictim.hearthstones.tavern.Owner;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernPos;

public final class TavernTextFormat {
    public static final double FAR_AWAY = 5000.0;
    public static final double NEARBY = 5.0;

    private TavernTextFormat() {
    }

    public static Component name(Tavern tavern) {
        return TavernTextFormat.formatName(tavern.name(), false);
    }

    public static Component owner(Tavern tavern) {
        return TavernTextFormat.formatOwner(tavern.owner());
    }

    public static Component distance(Tavern tavern, Entity entity) {
        return TavernTextFormat.formatDistance(tavern.pos(), entity);
    }

    public static Component position(Tavern tavern) {
        return TavernTextFormat.formatPosition(tavern.pos());
    }

    public static Component nameAndDistance(Tavern tavern, Entity entity) {
        return new TextComponent("").m_7220_(TavernTextFormat.name(tavern)).m_130946_(" - ").m_7220_(TavernTextFormat.distance(tavern, entity));
    }

    public static Component formatName(@Nullable String tavernName, boolean isMissing) {
        TranslatableComponent component = tavernName == null ? new TranslatableComponent("info.hearthstones.tavern.no_name") : new TextComponent(tavernName).m_130940_(ChatFormatting.BOLD);
        return isMissing ? component.m_130940_(ChatFormatting.RED) : component;
    }

    public static Component formatOwner(Owner owner) {
        return owner.hasOwner() ? new TranslatableComponent("info.hearthstones.tavern.owned_by", new Object[]{owner.getName()}).m_130940_(ChatFormatting.GREEN) : new TranslatableComponent("info.hearthstones.tavern.no_owner").m_130940_(ChatFormatting.RED);
    }

    public static Component formatDistance(TavernPos pos, Entity entity) {
        if (!pos.isSameDimension(entity.f_19853_)) {
            return new TranslatableComponent("info.hearthstones.tavern.another_dim");
        }
        double dist = Math.sqrt(entity.m_20275_((double)pos.pos().m_123341_() + 0.5, (double)pos.pos().m_123342_() + 0.5, (double)pos.pos().m_123343_() + 0.5));
        if (dist >= 5000.0) {
            return new TranslatableComponent("info.hearthstones.tavern.far_away");
        }
        if (dist <= 5.0) {
            return new TranslatableComponent("info.hearthstones.tavern.nearby");
        }
        return new TranslatableComponent("info.hearthstones.tavern.n_meter_away", new Object[]{DoubleMath.roundToInt((double)dist, (RoundingMode)RoundingMode.HALF_UP)});
    }

    public static Component formatPosition(TavernPos pos) {
        return new TextComponent(pos.toString()).m_130940_(ChatFormatting.DARK_GRAY);
    }
}

